/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.entity.mime;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.hc.client5.http.entity.mime.AbstractMultipartFormat;
import org.apache.hc.client5.http.entity.mime.Header;
import org.apache.hc.client5.http.entity.mime.MimeField;
import org.apache.hc.client5.http.entity.mime.MultipartPart;

class LegacyMultipart
extends AbstractMultipartFormat {
    private final List<MultipartPart> parts;

    public LegacyMultipart(Charset charset, String boundary, List<MultipartPart> parts) {
        super(charset, boundary);
        this.parts = parts;
    }

    @Override
    public List<MultipartPart> getParts() {
        return this.parts;
    }

    @Override
    protected void formatMultipartHeader(MultipartPart part2, OutputStream out2) throws IOException {
        String filename;
        Header header = part2.getHeader();
        MimeField cd2 = header.getField("Content-Disposition");
        if (cd2 != null) {
            LegacyMultipart.writeField(cd2, this.charset, out2);
        }
        if ((filename = part2.getBody().getFilename()) != null) {
            MimeField ct = header.getField("Content-Type");
            LegacyMultipart.writeField(ct, this.charset, out2);
        }
    }
}

