/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cookie;

import java.time.Instant;
import java.time.Month;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.BitSet;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hc.client5.http.cookie.CommonCookieAttributeHandler;
import org.apache.hc.client5.http.cookie.MalformedCookieException;
import org.apache.hc.client5.http.cookie.SetCookie;
import org.apache.hc.client5.http.impl.cookie.AbstractCookieAttributeHandler;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TextUtils;
import org.apache.hc.core5.util.Tokenizer;

@Contract(threading=ThreadingBehavior.STATELESS)
public class LaxExpiresHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    public static final LaxExpiresHandler INSTANCE;
    private static final BitSet DELIMS;
    private static final Map<String, Month> MONTHS;
    private static final Pattern TIME_PATTERN;
    private static final Pattern DAY_OF_MONTH_PATTERN;
    private static final Pattern MONTH_PATTERN;
    private static final Pattern YEAR_PATTERN;

    @Override
    public void parse(SetCookie cookie, String value2) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (TextUtils.isBlank(value2)) {
            return;
        }
        Tokenizer.Cursor cursor = new Tokenizer.Cursor(0, value2.length());
        StringBuilder content2 = new StringBuilder();
        int second2 = 0;
        int minute2 = 0;
        int hour2 = 0;
        int day2 = 0;
        int year2 = 0;
        Month month = Month.JANUARY;
        boolean foundTime = false;
        boolean foundDayOfMonth = false;
        boolean foundMonth = false;
        boolean foundYear = false;
        try {
            while (!cursor.atEnd()) {
                this.skipDelims(value2, cursor);
                content2.setLength(0);
                this.copyContent(value2, cursor, content2);
                if (content2.length() != 0) {
                    Matcher matcher;
                    if (!foundTime && (matcher = TIME_PATTERN.matcher(content2)).matches()) {
                        foundTime = true;
                        hour2 = Integer.parseInt(matcher.group(1));
                        minute2 = Integer.parseInt(matcher.group(2));
                        second2 = Integer.parseInt(matcher.group(3));
                        continue;
                    }
                    if (!foundDayOfMonth && (matcher = DAY_OF_MONTH_PATTERN.matcher(content2)).matches()) {
                        foundDayOfMonth = true;
                        day2 = Integer.parseInt(matcher.group(1));
                        continue;
                    }
                    if (!foundMonth && (matcher = MONTH_PATTERN.matcher(content2)).matches()) {
                        foundMonth = true;
                        month = MONTHS.get(matcher.group(1).toLowerCase(Locale.ROOT));
                        continue;
                    }
                    if (foundYear || !(matcher = YEAR_PATTERN.matcher(content2)).matches()) continue;
                    foundYear = true;
                    year2 = Integer.parseInt(matcher.group(1));
                    continue;
                }
                break;
            }
        }
        catch (NumberFormatException ignore) {
            throw new MalformedCookieException("Invalid 'expires' attribute: " + value2);
        }
        if (!(foundTime && foundDayOfMonth && foundMonth && foundYear)) {
            throw new MalformedCookieException("Invalid 'expires' attribute: " + value2);
        }
        if (year2 >= 70 && year2 <= 99) {
            year2 = 1900 + year2;
        }
        if (year2 >= 0 && year2 <= 69) {
            year2 = 2000 + year2;
        }
        if (day2 < 1 || day2 > 31 || year2 < 1601 || hour2 > 23 || minute2 > 59 || second2 > 59) {
            throw new MalformedCookieException("Invalid 'expires' attribute: " + value2);
        }
        Instant expiryDate = ZonedDateTime.of(year2, month.getValue(), day2, hour2, minute2, second2, 0, ZoneId.of("UTC")).toInstant();
        cookie.setExpiryDate(expiryDate);
    }

    private void skipDelims(CharSequence buf, Tokenizer.Cursor cursor) {
        char current;
        int pos = cursor.getPos();
        int indexFrom = cursor.getPos();
        int indexTo = cursor.getUpperBound();
        for (int i = indexFrom; i < indexTo && DELIMS.get(current = buf.charAt(i)); ++i) {
            ++pos;
        }
        cursor.updatePos(pos);
    }

    private void copyContent(CharSequence buf, Tokenizer.Cursor cursor, StringBuilder dst) {
        char current;
        int pos = cursor.getPos();
        int indexFrom = cursor.getPos();
        int indexTo = cursor.getUpperBound();
        for (int i = indexFrom; i < indexTo && !DELIMS.get(current = buf.charAt(i)); ++i) {
            ++pos;
            dst.append(current);
        }
        cursor.updatePos(pos);
    }

    @Override
    public String getAttributeName() {
        return "expires";
    }

    static {
        int b;
        INSTANCE = new LaxExpiresHandler();
        BitSet bitSet = new BitSet();
        bitSet.set(9);
        for (b = 32; b <= 47; ++b) {
            bitSet.set(b);
        }
        for (b = 59; b <= 64; ++b) {
            bitSet.set(b);
        }
        for (b = 91; b <= 96; ++b) {
            bitSet.set(b);
        }
        for (b = 123; b <= 126; ++b) {
            bitSet.set(b);
        }
        DELIMS = bitSet;
        ConcurrentHashMap<String, Month> map2 = new ConcurrentHashMap<String, Month>(12);
        map2.put("jan", Month.JANUARY);
        map2.put("feb", Month.FEBRUARY);
        map2.put("mar", Month.MARCH);
        map2.put("apr", Month.APRIL);
        map2.put("may", Month.MAY);
        map2.put("jun", Month.JUNE);
        map2.put("jul", Month.JULY);
        map2.put("aug", Month.AUGUST);
        map2.put("sep", Month.SEPTEMBER);
        map2.put("oct", Month.OCTOBER);
        map2.put("nov", Month.NOVEMBER);
        map2.put("dec", Month.DECEMBER);
        MONTHS = map2;
        TIME_PATTERN = Pattern.compile("^([0-9]{1,2}):([0-9]{1,2}):([0-9]{1,2})([^0-9].*)?$");
        DAY_OF_MONTH_PATTERN = Pattern.compile("^([0-9]{1,2})([^0-9].*)?$");
        MONTH_PATTERN = Pattern.compile("^(jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec)(.*)?$", 2);
        YEAR_PATTERN = Pattern.compile("^([0-9]{2,4})([^0-9].*)?$");
    }
}

