/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.io;

import java.io.IOException;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ConnectionReuseStrategy;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.UnsupportedHttpVersionException;
import org.apache.hc.core5.http.impl.DefaultConnectionReuseStrategy;
import org.apache.hc.core5.http.impl.Http1StreamListener;
import org.apache.hc.core5.http.io.HttpClientConnection;
import org.apache.hc.core5.http.io.HttpResponseInformationCallback;
import org.apache.hc.core5.http.message.MessageSupport;
import org.apache.hc.core5.http.message.StatusLine;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.io.Closer;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Timeout;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class HttpRequestExecutor {
    public static final Timeout DEFAULT_WAIT_FOR_CONTINUE = Timeout.ofSeconds(3L);
    private final Timeout waitForContinue;
    private final ConnectionReuseStrategy connReuseStrategy;
    private final Http1StreamListener streamListener;

    public HttpRequestExecutor(Timeout waitForContinue, ConnectionReuseStrategy connReuseStrategy, Http1StreamListener streamListener) {
        this.waitForContinue = Args.positive(waitForContinue, "Wait for continue time");
        this.connReuseStrategy = connReuseStrategy != null ? connReuseStrategy : DefaultConnectionReuseStrategy.INSTANCE;
        this.streamListener = streamListener;
    }

    public HttpRequestExecutor(ConnectionReuseStrategy connReuseStrategy) {
        this(DEFAULT_WAIT_FOR_CONTINUE, connReuseStrategy, null);
    }

    public HttpRequestExecutor() {
        this(DEFAULT_WAIT_FOR_CONTINUE, null, null);
    }

    public ClassicHttpResponse execute(ClassicHttpRequest request2, HttpClientConnection conn, HttpResponseInformationCallback informationCallback, HttpContext context) throws IOException, HttpException {
        Args.notNull(request2, "HTTP request");
        Args.notNull(conn, "Client connection");
        Args.notNull(context, "HTTP context");
        try {
            context.setAttribute("http.ssl-session", conn.getSSLSession());
            context.setAttribute("http.connection-endpoint", conn.getEndpointDetails());
            conn.sendRequestHeader(request2);
            if (this.streamListener != null) {
                this.streamListener.onRequestHead(conn, request2);
            }
            boolean expectContinue = false;
            HttpEntity entity = request2.getEntity();
            if (entity != null) {
                Header expect = request2.getFirstHeader("Expect");
                boolean bl = expectContinue = expect != null && "100-continue".equalsIgnoreCase(expect.getValue());
                if (!expectContinue) {
                    conn.sendRequestEntity(request2);
                }
            }
            conn.flush();
            ClassicHttpResponse response2 = null;
            while (response2 == null) {
                int status;
                if (expectContinue) {
                    if (conn.isDataAvailable(this.waitForContinue)) {
                        response2 = conn.receiveResponseHeader();
                        if (this.streamListener != null) {
                            this.streamListener.onResponseHead(conn, response2);
                        }
                        if ((status = response2.getCode()) == 100) {
                            response2 = null;
                            conn.sendRequestEntity(request2);
                        } else {
                            if (status < 200) {
                                if (informationCallback != null) {
                                    informationCallback.execute(response2, conn, context);
                                }
                                response2 = null;
                                continue;
                            }
                            if (status >= 400) {
                                conn.terminateRequest(request2);
                            } else {
                                conn.sendRequestEntity(request2);
                            }
                        }
                    } else {
                        conn.sendRequestEntity(request2);
                    }
                    conn.flush();
                    expectContinue = false;
                    continue;
                }
                response2 = conn.receiveResponseHeader();
                if (this.streamListener != null) {
                    this.streamListener.onResponseHead(conn, response2);
                }
                if ((status = response2.getCode()) < 100) {
                    throw new ProtocolException("Invalid response: " + new StatusLine(response2));
                }
                if (status >= 200) continue;
                if (informationCallback != null && status != 100) {
                    informationCallback.execute(response2, conn, context);
                }
                response2 = null;
            }
            if (MessageSupport.canResponseHaveBody(request2.getMethod(), response2)) {
                conn.receiveResponseEntity(response2);
            }
            return response2;
        }
        catch (IOException | RuntimeException | HttpException ex) {
            Closer.closeQuietly(conn);
            throw ex;
        }
    }

    public ClassicHttpResponse execute(ClassicHttpRequest request2, HttpClientConnection conn, HttpContext context) throws IOException, HttpException {
        return this.execute(request2, conn, null, context);
    }

    public void preProcess(ClassicHttpRequest request2, HttpProcessor processor, HttpContext context) throws HttpException, IOException {
        Args.notNull(request2, "HTTP request");
        Args.notNull(processor, "HTTP processor");
        Args.notNull(context, "HTTP context");
        ProtocolVersion transportVersion = request2.getVersion();
        if (transportVersion != null && transportVersion.greaterEquals(HttpVersion.HTTP_2)) {
            throw new UnsupportedHttpVersionException(transportVersion);
        }
        context.setProtocolVersion(transportVersion != null ? transportVersion : HttpVersion.HTTP_1_1);
        context.setAttribute("http.request", request2);
        processor.process(request2, (EntityDetails)request2.getEntity(), context);
    }

    public void postProcess(ClassicHttpResponse response2, HttpProcessor processor, HttpContext context) throws HttpException, IOException {
        Args.notNull(response2, "HTTP response");
        Args.notNull(processor, "HTTP processor");
        Args.notNull(context, "HTTP context");
        ProtocolVersion transportVersion = response2.getVersion();
        context.setProtocolVersion(transportVersion != null ? transportVersion : HttpVersion.HTTP_1_1);
        context.setAttribute("http.response", response2);
        processor.process(response2, (EntityDetails)response2.getEntity(), context);
    }

    public boolean keepAlive(ClassicHttpRequest request2, ClassicHttpResponse response2, HttpClientConnection connection, HttpContext context) throws IOException {
        boolean keepAlive;
        Args.notNull(connection, "HTTP connection");
        Args.notNull(request2, "HTTP request");
        Args.notNull(response2, "HTTP response");
        Args.notNull(context, "HTTP context");
        boolean bl = keepAlive = connection.isConsistent() && this.connReuseStrategy.keepAlive(request2, response2, context);
        if (this.streamListener != null) {
            this.streamListener.onExchangeComplete(connection, keepAlive);
        }
        return keepAlive;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Timeout waitForContinue;
        private ConnectionReuseStrategy connReuseStrategy;
        private Http1StreamListener streamListener;

        private Builder() {
        }

        public Builder withWaitForContinue(Timeout waitForContinue) {
            this.waitForContinue = waitForContinue;
            return this;
        }

        public Builder withConnectionReuseStrategy(ConnectionReuseStrategy connReuseStrategy) {
            this.connReuseStrategy = connReuseStrategy;
            return this;
        }

        public Builder withHttp1StreamListener(Http1StreamListener streamListener) {
            this.streamListener = streamListener;
            return this;
        }

        public HttpRequestExecutor build() {
            return new HttpRequestExecutor(this.waitForContinue, this.connReuseStrategy, this.streamListener);
        }
    }
}

