/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.nio.entity;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.nio.DataStreamChannel;
import org.apache.hc.core5.util.Args;

public class BasicAsyncEntityProducer
implements AsyncEntityProducer {
    private final ByteBuffer bytebuf;
    private final int length;
    private final ContentType contentType;
    private final boolean chunked;
    private final AtomicReference<Exception> exception;

    public BasicAsyncEntityProducer(byte[] content2, ContentType contentType2, boolean chunked) {
        Args.notNull(content2, "Content");
        this.bytebuf = ByteBuffer.wrap(content2);
        this.length = this.bytebuf.remaining();
        this.contentType = contentType2;
        this.chunked = chunked;
        this.exception = new AtomicReference();
    }

    public BasicAsyncEntityProducer(byte[] content2, ContentType contentType2) {
        this(content2, contentType2, false);
    }

    public BasicAsyncEntityProducer(byte[] content2) {
        this(content2, ContentType.APPLICATION_OCTET_STREAM);
    }

    public BasicAsyncEntityProducer(CharSequence content2, ContentType contentType2, boolean chunked) {
        Args.notNull(content2, "Content");
        this.contentType = contentType2;
        Charset charset = ContentType.getCharset(contentType2, StandardCharsets.US_ASCII);
        this.bytebuf = charset.encode(CharBuffer.wrap(content2));
        this.length = this.bytebuf.remaining();
        this.chunked = chunked;
        this.exception = new AtomicReference();
    }

    public BasicAsyncEntityProducer(CharSequence content2, ContentType contentType2) {
        this(content2, contentType2, false);
    }

    public BasicAsyncEntityProducer(CharSequence content2) {
        this(content2, ContentType.TEXT_PLAIN);
    }

    @Override
    public boolean isRepeatable() {
        return true;
    }

    @Override
    public final String getContentType() {
        return this.contentType != null ? this.contentType.toString() : null;
    }

    @Override
    public long getContentLength() {
        return this.length;
    }

    @Override
    public int available() {
        return Integer.MAX_VALUE;
    }

    @Override
    public String getContentEncoding() {
        return null;
    }

    @Override
    public boolean isChunked() {
        return this.chunked;
    }

    @Override
    public Set<String> getTrailerNames() {
        return null;
    }

    @Override
    public final void produce(DataStreamChannel channel2) throws IOException {
        if (this.bytebuf.hasRemaining()) {
            channel2.write(this.bytebuf);
        }
        if (!this.bytebuf.hasRemaining()) {
            channel2.endStream();
        }
    }

    @Override
    public final void failed(Exception cause) {
        if (this.exception.compareAndSet(null, cause)) {
            this.releaseResources();
        }
    }

    public final Exception getException() {
        return this.exception.get();
    }

    @Override
    public void releaseResources() {
        this.bytebuf.clear();
        this.bytebuf.limit(this.length);
    }
}

