/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.hpack;

import java.nio.ByteBuffer;
import org.apache.hc.core5.http2.hpack.HPackException;
import org.apache.hc.core5.http2.hpack.HuffmanNode;
import org.apache.hc.core5.util.ByteArrayBuffer;

final class HuffmanDecoder {
    private final HuffmanNode root;

    HuffmanDecoder(int[] codes, byte[] lengths) {
        this.root = HuffmanDecoder.buildTree(codes, lengths);
    }

    void decode(ByteArrayBuffer out2, ByteBuffer src) throws HPackException {
        int c;
        HuffmanNode node2 = this.root;
        int current = 0;
        int bits = 0;
        while (src.hasRemaining()) {
            int b = src.get() & 0xFF;
            current = current << 8 | b;
            bits += 8;
            while (bits >= 8) {
                int c2 = current >>> bits - 8 & 0xFF;
                node2 = node2.getChild(c2);
                bits -= node2.getBits();
                if (!node2.isTerminal()) continue;
                if (node2.getSymbol() == 256) {
                    throw new HPackException("EOS decoded");
                }
                out2.append(node2.getSymbol());
                node2 = this.root;
            }
        }
        while (bits > 0 && (node2 = node2.getChild(c = current << 8 - bits & 0xFF)).isTerminal() && node2.getBits() <= bits) {
            bits -= node2.getBits();
            out2.append(node2.getSymbol());
            node2 = this.root;
        }
        int mask = (1 << bits) - 1;
        if ((current & mask) != mask) {
            throw new HPackException("Invalid padding");
        }
    }

    private static HuffmanNode buildTree(int[] codes, byte[] lengths) {
        HuffmanNode root = new HuffmanNode();
        for (int symbol = 0; symbol < codes.length; ++symbol) {
            int code = codes[symbol];
            int length = lengths[symbol];
            HuffmanNode current = root;
            while (length > 8) {
                if (current.isTerminal()) {
                    throw new IllegalStateException("Invalid Huffman code: prefix not unique");
                }
                int i = code >>> (length -= 8) & 0xFF;
                if (!current.hasChild(i)) {
                    current.setChild(i, new HuffmanNode());
                }
                current = current.getChild(i);
            }
            HuffmanNode terminal = new HuffmanNode(symbol, length);
            int shift = 8 - length;
            int start2 = code << shift & 0xFF;
            int end2 = 1 << shift;
            for (int i = start2; i < start2 + end2; ++i) {
                current.setChild(i, terminal);
            }
        }
        return root;
    }
}

