/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.execchain;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.annotation.Contract;
import org.apache.http.annotation.ThreadingBehavior;
import org.apache.http.auth.AuthProtocolState;
import org.apache.http.auth.AuthState;
import org.apache.http.client.AuthenticationStrategy;
import org.apache.http.client.NonRepeatableRequestException;
import org.apache.http.client.UserTokenHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpExecutionAware;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.ConnectionRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.BasicRouteDirector;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.HttpRouteDirector;
import org.apache.http.conn.routing.RouteTracker;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.impl.auth.HttpAuthenticator;
import org.apache.http.impl.conn.ConnectionShutdownException;
import org.apache.http.impl.execchain.ClientExecChain;
import org.apache.http.impl.execchain.ConnectionHolder;
import org.apache.http.impl.execchain.HttpResponseProxy;
import org.apache.http.impl.execchain.RequestAbortedException;
import org.apache.http.impl.execchain.RequestEntityProxy;
import org.apache.http.impl.execchain.TunnelRefusedException;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestExecutor;
import org.apache.http.protocol.ImmutableHttpProcessor;
import org.apache.http.protocol.RequestTargetHost;
import org.apache.http.util.Args;
import org.apache.http.util.EntityUtils;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class MainClientExec
implements ClientExecChain {
    private final Log log = LogFactory.getLog(this.getClass());
    private final HttpRequestExecutor requestExecutor;
    private final HttpClientConnectionManager connManager;
    private final ConnectionReuseStrategy reuseStrategy;
    private final ConnectionKeepAliveStrategy keepAliveStrategy;
    private final HttpProcessor proxyHttpProcessor;
    private final AuthenticationStrategy targetAuthStrategy;
    private final AuthenticationStrategy proxyAuthStrategy;
    private final HttpAuthenticator authenticator;
    private final UserTokenHandler userTokenHandler;
    private final HttpRouteDirector routeDirector;

    public MainClientExec(HttpRequestExecutor requestExecutor, HttpClientConnectionManager connManager, ConnectionReuseStrategy reuseStrategy, ConnectionKeepAliveStrategy keepAliveStrategy, HttpProcessor proxyHttpProcessor, AuthenticationStrategy targetAuthStrategy, AuthenticationStrategy proxyAuthStrategy, UserTokenHandler userTokenHandler) {
        Args.notNull(requestExecutor, "HTTP request executor");
        Args.notNull(connManager, "Client connection manager");
        Args.notNull(reuseStrategy, "Connection reuse strategy");
        Args.notNull(keepAliveStrategy, "Connection keep alive strategy");
        Args.notNull(proxyHttpProcessor, "Proxy HTTP processor");
        Args.notNull(targetAuthStrategy, "Target authentication strategy");
        Args.notNull(proxyAuthStrategy, "Proxy authentication strategy");
        Args.notNull(userTokenHandler, "User token handler");
        this.authenticator = new HttpAuthenticator();
        this.routeDirector = new BasicRouteDirector();
        this.requestExecutor = requestExecutor;
        this.connManager = connManager;
        this.reuseStrategy = reuseStrategy;
        this.keepAliveStrategy = keepAliveStrategy;
        this.proxyHttpProcessor = proxyHttpProcessor;
        this.targetAuthStrategy = targetAuthStrategy;
        this.proxyAuthStrategy = proxyAuthStrategy;
        this.userTokenHandler = userTokenHandler;
    }

    public MainClientExec(HttpRequestExecutor requestExecutor, HttpClientConnectionManager connManager, ConnectionReuseStrategy reuseStrategy, ConnectionKeepAliveStrategy keepAliveStrategy, AuthenticationStrategy targetAuthStrategy, AuthenticationStrategy proxyAuthStrategy, UserTokenHandler userTokenHandler) {
        this(requestExecutor, connManager, reuseStrategy, keepAliveStrategy, new ImmutableHttpProcessor(new RequestTargetHost()), targetAuthStrategy, proxyAuthStrategy, userTokenHandler);
    }

    @Override
    public CloseableHttpResponse execute(HttpRoute route, HttpRequestWrapper request2, HttpClientContext context, HttpExecutionAware execAware) throws IOException, HttpException {
        HttpClientConnection managedConn;
        AuthState proxyAuthState;
        Args.notNull(route, "HTTP route");
        Args.notNull(request2, "HTTP request");
        Args.notNull(context, "HTTP context");
        AuthState targetAuthState = context.getTargetAuthState();
        if (targetAuthState == null) {
            targetAuthState = new AuthState();
            context.setAttribute("http.auth.target-scope", targetAuthState);
        }
        if ((proxyAuthState = context.getProxyAuthState()) == null) {
            proxyAuthState = new AuthState();
            context.setAttribute("http.auth.proxy-scope", proxyAuthState);
        }
        if (request2 instanceof HttpEntityEnclosingRequest) {
            RequestEntityProxy.enhance((HttpEntityEnclosingRequest)((Object)request2));
        }
        Object userToken = context.getUserToken();
        ConnectionRequest connRequest = this.connManager.requestConnection(route, userToken);
        if (execAware != null) {
            if (execAware.isAborted()) {
                connRequest.cancel();
                throw new RequestAbortedException("Request aborted");
            }
            execAware.setCancellable(connRequest);
        }
        RequestConfig config2 = context.getRequestConfig();
        try {
            int timeout2 = config2.getConnectionRequestTimeout();
            managedConn = connRequest.get(timeout2 > 0 ? (long)timeout2 : 0L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interrupted) {
            Thread.currentThread().interrupt();
            throw new RequestAbortedException("Request aborted", interrupted);
        }
        catch (ExecutionException ex) {
            Throwable cause = ex.getCause();
            if (cause == null) {
                cause = ex;
            }
            throw new RequestAbortedException("Request execution failed", cause);
        }
        context.setAttribute("http.connection", managedConn);
        if (config2.isStaleConnectionCheckEnabled() && managedConn.isOpen()) {
            this.log.debug("Stale connection check");
            if (managedConn.isStale()) {
                this.log.debug("Stale connection detected");
                managedConn.close();
            }
        }
        ConnectionHolder connHolder = new ConnectionHolder(this.log, this.connManager, managedConn);
        try {
            HttpEntity entity;
            HttpResponse response2;
            if (execAware != null) {
                execAware.setCancellable(connHolder);
            }
            int execCount = 1;
            while (true) {
                int timeout3;
                if (execCount > 1 && !RequestEntityProxy.isRepeatable(request2)) {
                    throw new NonRepeatableRequestException("Cannot retry request with a non-repeatable request entity.");
                }
                if (execAware != null && execAware.isAborted()) {
                    throw new RequestAbortedException("Request aborted");
                }
                if (!managedConn.isOpen()) {
                    this.log.debug("Opening connection " + route);
                    try {
                        this.establishRoute(proxyAuthState, managedConn, route, request2, context);
                    }
                    catch (TunnelRefusedException ex) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug(ex.getMessage());
                        }
                        response2 = ex.getResponse();
                        break;
                    }
                }
                if ((timeout3 = config2.getSocketTimeout()) >= 0) {
                    managedConn.setSocketTimeout(timeout3);
                }
                if (execAware != null && execAware.isAborted()) {
                    throw new RequestAbortedException("Request aborted");
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Executing request " + request2.getRequestLine());
                }
                if (!request2.containsHeader("Authorization")) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Target auth state: " + (Object)((Object)targetAuthState.getState()));
                    }
                    this.authenticator.generateAuthResponse(request2, targetAuthState, context);
                }
                if (!request2.containsHeader("Proxy-Authorization") && !route.isTunnelled()) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Proxy auth state: " + (Object)((Object)proxyAuthState.getState()));
                    }
                    this.authenticator.generateAuthResponse(request2, proxyAuthState, context);
                }
                context.setAttribute("http.request", request2);
                response2 = this.requestExecutor.execute(request2, managedConn, context);
                if (this.reuseStrategy.keepAlive(response2, context)) {
                    long duration = this.keepAliveStrategy.getKeepAliveDuration(response2, context);
                    if (this.log.isDebugEnabled()) {
                        String s2 = duration > 0L ? "for " + duration + " " + (Object)((Object)TimeUnit.MILLISECONDS) : "indefinitely";
                        this.log.debug("Connection can be kept alive " + s2);
                    }
                    connHolder.setValidFor(duration, TimeUnit.MILLISECONDS);
                    connHolder.markReusable();
                } else {
                    connHolder.markNonReusable();
                }
                if (!this.needAuthentication(targetAuthState, proxyAuthState, route, response2, context)) break;
                HttpEntity entity2 = response2.getEntity();
                if (connHolder.isReusable()) {
                    EntityUtils.consume(entity2);
                } else {
                    managedConn.close();
                    if (proxyAuthState.getState() == AuthProtocolState.SUCCESS && proxyAuthState.isConnectionBased()) {
                        this.log.debug("Resetting proxy auth state");
                        proxyAuthState.reset();
                    }
                    if (targetAuthState.getState() == AuthProtocolState.SUCCESS && targetAuthState.isConnectionBased()) {
                        this.log.debug("Resetting target auth state");
                        targetAuthState.reset();
                    }
                }
                HttpRequest original = request2.getOriginal();
                if (!original.containsHeader("Authorization")) {
                    request2.removeHeaders("Authorization");
                }
                if (!original.containsHeader("Proxy-Authorization")) {
                    request2.removeHeaders("Proxy-Authorization");
                }
                ++execCount;
            }
            if (userToken == null) {
                userToken = this.userTokenHandler.getUserToken(context);
                context.setAttribute("http.user-token", userToken);
            }
            if (userToken != null) {
                connHolder.setState(userToken);
            }
            if ((entity = response2.getEntity()) == null || !entity.isStreaming()) {
                connHolder.releaseConnection();
                return new HttpResponseProxy(response2, null);
            }
            return new HttpResponseProxy(response2, connHolder);
        }
        catch (ConnectionShutdownException ex) {
            InterruptedIOException ioex = new InterruptedIOException("Connection has been shut down");
            ioex.initCause(ex);
            throw ioex;
        }
        catch (HttpException ex) {
            connHolder.abortConnection();
            throw ex;
        }
        catch (IOException ex) {
            connHolder.abortConnection();
            if (proxyAuthState.isConnectionBased()) {
                proxyAuthState.reset();
            }
            if (targetAuthState.isConnectionBased()) {
                targetAuthState.reset();
            }
            throw ex;
        }
        catch (RuntimeException ex) {
            connHolder.abortConnection();
            if (proxyAuthState.isConnectionBased()) {
                proxyAuthState.reset();
            }
            if (targetAuthState.isConnectionBased()) {
                targetAuthState.reset();
            }
            throw ex;
        }
        catch (Error error) {
            this.connManager.shutdown();
            throw error;
        }
    }

    void establishRoute(AuthState proxyAuthState, HttpClientConnection managedConn, HttpRoute route, HttpRequest request2, HttpClientContext context) throws HttpException, IOException {
        int step;
        RequestConfig config2 = context.getRequestConfig();
        int timeout2 = config2.getConnectTimeout();
        RouteTracker tracker = new RouteTracker(route);
        do {
            HttpRoute fact = tracker.toRoute();
            step = this.routeDirector.nextStep(route, fact);
            switch (step) {
                case 1: {
                    this.connManager.connect(managedConn, route, timeout2 > 0 ? timeout2 : 0, context);
                    tracker.connectTarget(route.isSecure());
                    break;
                }
                case 2: {
                    this.connManager.connect(managedConn, route, timeout2 > 0 ? timeout2 : 0, context);
                    HttpHost proxy = route.getProxyHost();
                    tracker.connectProxy(proxy, route.isSecure() && !route.isTunnelled());
                    break;
                }
                case 3: {
                    boolean secure = this.createTunnelToTarget(proxyAuthState, managedConn, route, request2, context);
                    this.log.debug("Tunnel to target created.");
                    tracker.tunnelTarget(secure);
                    break;
                }
                case 4: {
                    int hop = fact.getHopCount() - 1;
                    boolean secure = this.createTunnelToProxy(route, hop, context);
                    this.log.debug("Tunnel to proxy created.");
                    tracker.tunnelProxy(route.getHopTarget(hop), secure);
                    break;
                }
                case 5: {
                    this.connManager.upgrade(managedConn, route, context);
                    tracker.layerProtocol(route.isSecure());
                    break;
                }
                case -1: {
                    throw new HttpException("Unable to establish route: planned = " + route + "; current = " + fact);
                }
                case 0: {
                    this.connManager.routeComplete(managedConn, route, context);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown step indicator " + step + " from RouteDirector.");
                }
            }
        } while (step > 0);
    }

    private boolean createTunnelToTarget(AuthState proxyAuthState, HttpClientConnection managedConn, HttpRoute route, HttpRequest request2, HttpClientContext context) throws HttpException, IOException {
        HttpEntity entity;
        int status;
        RequestConfig config2 = context.getRequestConfig();
        int timeout2 = config2.getConnectTimeout();
        HttpHost target = route.getTargetHost();
        HttpHost proxy = route.getProxyHost();
        HttpResponse response2 = null;
        String authority = target.toHostString();
        BasicHttpRequest connect2 = new BasicHttpRequest("CONNECT", authority, request2.getProtocolVersion());
        this.requestExecutor.preProcess(connect2, this.proxyHttpProcessor, context);
        while (response2 == null) {
            if (!managedConn.isOpen()) {
                this.connManager.connect(managedConn, route, timeout2 > 0 ? timeout2 : 0, context);
            }
            connect2.removeHeaders("Proxy-Authorization");
            this.authenticator.generateAuthResponse(connect2, proxyAuthState, context);
            response2 = this.requestExecutor.execute(connect2, managedConn, context);
            this.requestExecutor.postProcess(response2, this.proxyHttpProcessor, context);
            status = response2.getStatusLine().getStatusCode();
            if (status < 200) {
                throw new HttpException("Unexpected response to CONNECT request: " + response2.getStatusLine());
            }
            if (!config2.isAuthenticationEnabled() || !this.authenticator.isAuthenticationRequested(proxy, response2, this.proxyAuthStrategy, proxyAuthState, context) || !this.authenticator.handleAuthChallenge(proxy, response2, this.proxyAuthStrategy, proxyAuthState, context)) continue;
            if (this.reuseStrategy.keepAlive(response2, context)) {
                this.log.debug("Connection kept alive");
                entity = response2.getEntity();
                EntityUtils.consume(entity);
            } else {
                managedConn.close();
            }
            response2 = null;
        }
        status = response2.getStatusLine().getStatusCode();
        if (status > 299) {
            entity = response2.getEntity();
            if (entity != null) {
                response2.setEntity(new BufferedHttpEntity(entity));
            }
            managedConn.close();
            throw new TunnelRefusedException("CONNECT refused by proxy: " + response2.getStatusLine(), response2);
        }
        return false;
    }

    private boolean createTunnelToProxy(HttpRoute route, int hop, HttpClientContext context) throws HttpException {
        throw new HttpException("Proxy chains are not supported.");
    }

    private boolean needAuthentication(AuthState targetAuthState, AuthState proxyAuthState, HttpRoute route, HttpResponse response2, HttpClientContext context) {
        RequestConfig config2 = context.getRequestConfig();
        if (config2.isAuthenticationEnabled()) {
            HttpHost target = context.getTargetHost();
            if (target == null) {
                target = route.getTargetHost();
            }
            if (target.getPort() < 0) {
                target = new HttpHost(target.getHostName(), route.getTargetHost().getPort(), target.getSchemeName());
            }
            boolean targetAuthRequested = this.authenticator.isAuthenticationRequested(target, response2, this.targetAuthStrategy, targetAuthState, context);
            HttpHost proxy = route.getProxyHost();
            if (proxy == null) {
                proxy = route.getTargetHost();
            }
            boolean proxyAuthRequested = this.authenticator.isAuthenticationRequested(proxy, response2, this.proxyAuthStrategy, proxyAuthState, context);
            if (targetAuthRequested) {
                return this.authenticator.handleAuthChallenge(target, response2, this.targetAuthStrategy, targetAuthState, context);
            }
            if (proxyAuthRequested) {
                return this.authenticator.handleAuthChallenge(proxy, response2, this.proxyAuthStrategy, proxyAuthState, context);
            }
        }
        return false;
    }
}

