/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.nio;

import java.io.IOException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseFactory;
import org.apache.http.config.MessageConstraints;
import org.apache.http.entity.ContentLengthStrategy;
import org.apache.http.impl.nio.NHttpClientEventHandlerAdaptor;
import org.apache.http.impl.nio.NHttpConnectionBase;
import org.apache.http.impl.nio.codecs.DefaultHttpRequestWriter;
import org.apache.http.impl.nio.codecs.DefaultHttpRequestWriterFactory;
import org.apache.http.impl.nio.codecs.DefaultHttpResponseParser;
import org.apache.http.impl.nio.codecs.DefaultHttpResponseParserFactory;
import org.apache.http.nio.NHttpClientEventHandler;
import org.apache.http.nio.NHttpClientHandler;
import org.apache.http.nio.NHttpClientIOTarget;
import org.apache.http.nio.NHttpMessageParser;
import org.apache.http.nio.NHttpMessageParserFactory;
import org.apache.http.nio.NHttpMessageWriter;
import org.apache.http.nio.NHttpMessageWriterFactory;
import org.apache.http.nio.reactor.IOSession;
import org.apache.http.nio.reactor.SessionInputBuffer;
import org.apache.http.nio.reactor.SessionOutputBuffer;
import org.apache.http.nio.util.ByteBufferAllocator;
import org.apache.http.params.HttpParamConfig;
import org.apache.http.params.HttpParams;
import org.apache.http.util.Args;

public class DefaultNHttpClientConnection
extends NHttpConnectionBase
implements NHttpClientIOTarget {
    protected final NHttpMessageParser<HttpResponse> responseParser;
    protected final NHttpMessageWriter<HttpRequest> requestWriter;

    @Deprecated
    public DefaultNHttpClientConnection(IOSession session2, HttpResponseFactory responseFactory, ByteBufferAllocator allocator, HttpParams params) {
        super(session2, allocator, params);
        Args.notNull(responseFactory, "Response factory");
        this.responseParser = this.createResponseParser(this.inbuf, responseFactory, params);
        this.requestWriter = this.createRequestWriter(this.outbuf, params);
        this.hasBufferedInput = false;
        this.hasBufferedOutput = false;
        this.session.setBufferStatus(this);
    }

    public DefaultNHttpClientConnection(IOSession session2, int bufferSize, int fragmentSizeHint, ByteBufferAllocator allocator, CharsetDecoder charDecoder, CharsetEncoder charEncoder, MessageConstraints constraints, ContentLengthStrategy incomingContentStrategy, ContentLengthStrategy outgoingContentStrategy, NHttpMessageWriterFactory<HttpRequest> requestWriterFactory, NHttpMessageParserFactory<HttpResponse> responseParserFactory) {
        super(session2, bufferSize, fragmentSizeHint, allocator, charDecoder, charEncoder, constraints, incomingContentStrategy, outgoingContentStrategy);
        this.requestWriter = (requestWriterFactory != null ? requestWriterFactory : DefaultHttpRequestWriterFactory.INSTANCE).create(this.outbuf);
        this.responseParser = (responseParserFactory != null ? responseParserFactory : DefaultHttpResponseParserFactory.INSTANCE).create(this.inbuf, constraints);
    }

    public DefaultNHttpClientConnection(IOSession session2, int bufferSize, CharsetDecoder charDecoder, CharsetEncoder charEncoder, MessageConstraints constraints) {
        this(session2, bufferSize, bufferSize, null, charDecoder, charEncoder, constraints, null, null, null, null);
    }

    public DefaultNHttpClientConnection(IOSession session2, int bufferSize) {
        this(session2, bufferSize, bufferSize, null, null, null, null, null, null, null, null);
    }

    @Deprecated
    protected NHttpMessageParser<HttpResponse> createResponseParser(SessionInputBuffer buffer, HttpResponseFactory responseFactory, HttpParams params) {
        MessageConstraints constraints = HttpParamConfig.getMessageConstraints(params);
        return new DefaultHttpResponseParser(buffer, null, responseFactory, constraints);
    }

    @Deprecated
    protected NHttpMessageWriter<HttpRequest> createRequestWriter(SessionOutputBuffer buffer, HttpParams params) {
        return new DefaultHttpRequestWriter(buffer, null);
    }

    protected void onResponseReceived(HttpResponse response2) {
    }

    protected void onRequestSubmitted(HttpRequest request2) {
    }

    @Override
    public void resetInput() {
        this.response = null;
        this.contentDecoder = null;
        this.responseParser.reset();
    }

    @Override
    public void resetOutput() {
        this.request = null;
        this.contentEncoder = null;
        this.requestWriter.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consumeInput(NHttpClientEventHandler handler2) {
        if (this.status != 0) {
            this.session.clearEvent(1);
            return;
        }
        try {
            if (this.response == null) {
                int bytesRead;
                do {
                    if ((bytesRead = this.responseParser.fillBuffer(this.session.channel())) > 0) {
                        this.inTransportMetrics.incrementBytesTransferred(bytesRead);
                    }
                    this.response = this.responseParser.parse();
                } while (bytesRead > 0 && this.response == null);
                if (this.response != null) {
                    if (this.response.getStatusLine().getStatusCode() >= 200) {
                        HttpEntity entity = this.prepareDecoder(this.response);
                        this.response.setEntity(entity);
                        this.connMetrics.incrementResponseCount();
                    }
                    this.hasBufferedInput = this.inbuf.hasData();
                    this.onResponseReceived(this.response);
                    handler2.responseReceived(this);
                    if (this.contentDecoder == null) {
                        this.resetInput();
                    }
                }
                if (bytesRead == -1 && !this.inbuf.hasData()) {
                    handler2.endOfInput(this);
                }
            }
            if (this.contentDecoder != null && (this.session.getEventMask() & 1) > 0) {
                handler2.inputReady(this, this.contentDecoder);
                if (this.contentDecoder.isCompleted()) {
                    this.resetInput();
                }
            }
        }
        catch (HttpException ex) {
            this.resetInput();
            handler2.exception(this, ex);
        }
        catch (Exception ex) {
            handler2.exception(this, ex);
        }
        finally {
            this.hasBufferedInput = this.inbuf.hasData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void produceOutput(NHttpClientEventHandler handler2) {
        try {
            int bytesWritten;
            if (this.status == 0) {
                if (this.contentEncoder == null && !this.outbuf.hasData()) {
                    handler2.requestReady(this);
                }
                if (this.contentEncoder != null) {
                    handler2.outputReady(this, this.contentEncoder);
                    if (this.contentEncoder.isCompleted()) {
                        this.resetOutput();
                    }
                }
            }
            if (this.outbuf.hasData() && (bytesWritten = this.outbuf.flush(this.session.channel())) > 0) {
                this.outTransportMetrics.incrementBytesTransferred(bytesWritten);
            }
            if (!this.outbuf.hasData() && this.status == 1) {
                this.session.close();
                this.status = 2;
                this.resetOutput();
            }
        }
        catch (Exception ex) {
            handler2.exception(this, ex);
        }
        finally {
            this.hasBufferedOutput = this.outbuf.hasData();
        }
    }

    @Override
    public void submitRequest(HttpRequest request2) throws IOException, HttpException {
        Args.notNull(request2, "HTTP request");
        this.assertNotClosed();
        if (this.request != null) {
            throw new HttpException("Request already submitted");
        }
        this.onRequestSubmitted(request2);
        this.requestWriter.write(request2);
        this.hasBufferedOutput = this.outbuf.hasData();
        if (request2 instanceof HttpEntityEnclosingRequest && ((HttpEntityEnclosingRequest)request2).getEntity() != null) {
            this.prepareEncoder(request2);
            this.request = request2;
        }
        this.connMetrics.incrementRequestCount();
        this.session.setEvent(4);
    }

    @Override
    public boolean isRequestSubmitted() {
        return this.request != null;
    }

    @Override
    public void consumeInput(NHttpClientHandler handler2) {
        this.consumeInput(new NHttpClientEventHandlerAdaptor(handler2));
    }

    @Override
    public void produceOutput(NHttpClientHandler handler2) {
        this.produceOutput(new NHttpClientEventHandlerAdaptor(handler2));
    }
}

