/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import java.nio.ByteBuffer;
import org.apache.logging.log4j.core.layout.ByteBufferDestination;

public final class ByteBufferDestinationHelper {
    private ByteBufferDestinationHelper() {
    }

    public static void writeToUnsynchronized(ByteBuffer source2, ByteBufferDestination destination) {
        ByteBuffer destBuff = destination.getByteBuffer();
        while (source2.remaining() > destBuff.remaining()) {
            int originalLimit = source2.limit();
            source2.limit(Math.min(source2.limit(), source2.position() + destBuff.remaining()));
            destBuff.put(source2);
            source2.limit(originalLimit);
            destBuff = destination.drain(destBuff);
        }
        destBuff.put(source2);
    }

    public static void writeToUnsynchronized(byte[] data2, int offset, int length, ByteBufferDestination destination) {
        int currentLength;
        int chunk;
        ByteBuffer buffer = destination.getByteBuffer();
        int currentOffset = offset;
        for (currentLength = length; currentLength > buffer.remaining(); currentLength -= chunk) {
            chunk = buffer.remaining();
            buffer.put(data2, currentOffset, chunk);
            currentOffset += chunk;
            buffer = destination.drain(buffer);
        }
        buffer.put(data2, currentOffset, currentLength);
    }
}

