/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.pattern.AnsiConverter;
import org.apache.logging.log4j.core.pattern.AnsiEscape;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.core.pattern.PatternFormatter;
import org.apache.logging.log4j.core.pattern.PatternParser;
import org.apache.logging.log4j.util.PerformanceSensitive;
import org.apache.logging.log4j.util.Strings;

@Plugin(name="highlight", category="Converter")
@ConverterKeys(value={"highlight"})
@PerformanceSensitive(value={"allocation"})
public final class HighlightConverter
extends LogEventPatternConverter
implements AnsiConverter {
    private static final Map<String, String> DEFAULT_STYLES = new HashMap<String, String>();
    private static final Map<String, String> LOGBACK_STYLES = new HashMap<String, String>();
    private static final String STYLE_KEY = "STYLE";
    private static final String DISABLE_ANSI_KEY = "DISABLEANSI";
    private static final String NO_CONSOLE_NO_ANSI_KEY = "NOCONSOLENOANSI";
    private static final String STYLE_KEY_DEFAULT = "DEFAULT";
    private static final String STYLE_KEY_LOGBACK = "LOGBACK";
    private static final Map<String, Map<String, String>> STYLES = new HashMap<String, Map<String, String>>();
    private final Map<String, String> levelStyles;
    private final List<PatternFormatter> patternFormatters;
    private final boolean noAnsi;
    private final String defaultStyle;

    private static Map<String, String> createLevelStyleMap(String[] options2) {
        if (options2.length < 2) {
            return DEFAULT_STYLES;
        }
        Map<String, String> styles = AnsiEscape.createMap(options2[1], new String[]{STYLE_KEY, DISABLE_ANSI_KEY, NO_CONSOLE_NO_ANSI_KEY});
        HashMap<String, String> levelStyles = new HashMap<String, String>(DEFAULT_STYLES);
        for (Map.Entry<String, String> entry : styles.entrySet()) {
            String key2 = Strings.toRootUpperCase(entry.getKey());
            String value2 = entry.getValue();
            if (STYLE_KEY.equalsIgnoreCase(key2)) {
                Map<String, String> enumMap = STYLES.get(Strings.toRootUpperCase(value2));
                if (enumMap == null) {
                    LOGGER.error("Unknown level style: " + value2 + ". Use one of " + Arrays.toString(STYLES.keySet().toArray()));
                    continue;
                }
                levelStyles.putAll(enumMap);
                continue;
            }
            if (DISABLE_ANSI_KEY.equalsIgnoreCase(key2) || NO_CONSOLE_NO_ANSI_KEY.equalsIgnoreCase(key2)) continue;
            Level level = Level.toLevel(key2, null);
            if (level == null) {
                LOGGER.warn("Setting style for yet unknown level name {}", (Object)key2);
                levelStyles.put(key2, value2);
                continue;
            }
            levelStyles.put(level.name(), value2);
        }
        return levelStyles;
    }

    public static HighlightConverter newInstance(Configuration config2, String[] options2) {
        if (options2.length < 1) {
            LOGGER.error("Incorrect number of options on style. Expected at least 1, received " + options2.length);
            return null;
        }
        if (options2[0] == null) {
            LOGGER.error("No pattern supplied on style");
            return null;
        }
        PatternParser parser = PatternLayout.createPatternParser(config2);
        List<PatternFormatter> formatters = parser.parse(options2[0]);
        boolean disableAnsi = Arrays.toString(options2).contains("disableAnsi=true");
        boolean noConsoleNoAnsi = Arrays.toString(options2).contains("noConsoleNoAnsi=true");
        boolean hideAnsi = disableAnsi || noConsoleNoAnsi && System.console() == null;
        return new HighlightConverter(formatters, HighlightConverter.createLevelStyleMap(options2), hideAnsi);
    }

    private HighlightConverter(List<PatternFormatter> patternFormatters, Map<String, String> levelStyles, boolean noAnsi) {
        super("style", "style");
        this.patternFormatters = patternFormatters;
        this.levelStyles = levelStyles;
        this.defaultStyle = AnsiEscape.getDefaultStyle();
        this.noAnsi = noAnsi;
    }

    @Override
    public void format(LogEvent event, StringBuilder toAppendTo) {
        boolean empty2;
        int start2 = 0;
        int end2 = 0;
        String levelStyle = this.levelStyles.get(event.getLevel().name());
        if (!this.noAnsi) {
            start2 = toAppendTo.length();
            if (levelStyle != null) {
                toAppendTo.append(levelStyle);
            }
            end2 = toAppendTo.length();
        }
        int size = this.patternFormatters.size();
        for (int i = 0; i < size; ++i) {
            this.patternFormatters.get(i).format(event, toAppendTo);
        }
        boolean bl = empty2 = toAppendTo.length() == end2;
        if (!this.noAnsi) {
            if (empty2) {
                toAppendTo.setLength(start2);
            } else if (levelStyle != null) {
                toAppendTo.append(this.defaultStyle);
            }
        }
    }

    String getLevelStyle(Level level) {
        return this.levelStyles.get(level.name());
    }

    @Override
    public boolean handlesThrowable() {
        for (PatternFormatter formatter : this.patternFormatters) {
            if (!formatter.handlesThrowable()) continue;
            return true;
        }
        return false;
    }

    static {
        DEFAULT_STYLES.put(Level.FATAL.name(), AnsiEscape.createSequence("BRIGHT", "RED"));
        DEFAULT_STYLES.put(Level.ERROR.name(), AnsiEscape.createSequence("BRIGHT", "RED"));
        DEFAULT_STYLES.put(Level.WARN.name(), AnsiEscape.createSequence("YELLOW"));
        DEFAULT_STYLES.put(Level.INFO.name(), AnsiEscape.createSequence("GREEN"));
        DEFAULT_STYLES.put(Level.DEBUG.name(), AnsiEscape.createSequence("CYAN"));
        DEFAULT_STYLES.put(Level.TRACE.name(), AnsiEscape.createSequence("BLACK"));
        LOGBACK_STYLES.put(Level.FATAL.name(), AnsiEscape.createSequence("BLINK", "BRIGHT", "RED"));
        LOGBACK_STYLES.put(Level.ERROR.name(), AnsiEscape.createSequence("BRIGHT", "RED"));
        LOGBACK_STYLES.put(Level.WARN.name(), AnsiEscape.createSequence("RED"));
        LOGBACK_STYLES.put(Level.INFO.name(), AnsiEscape.createSequence("BLUE"));
        LOGBACK_STYLES.put(Level.DEBUG.name(), AnsiEscape.createSequence(null));
        LOGBACK_STYLES.put(Level.TRACE.name(), AnsiEscape.createSequence(null));
        STYLES.put(STYLE_KEY_DEFAULT, DEFAULT_STYLES);
        STYLES.put(STYLE_KEY_LOGBACK, LOGBACK_STYLES);
    }
}

