/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import aQute.bnd.annotation.spi.ServiceProvider;
import java.util.Collection;
import java.util.Objects;
import org.apache.logging.log4j.util.BiConsumer;
import org.apache.logging.log4j.util.PropertySource;

@ServiceProvider(value=PropertySource.class, resolution="optional")
public class SystemPropertiesPropertySource
implements PropertySource {
    private static final int DEFAULT_PRIORITY = 0;
    private static final String PREFIX = "log4j2.";

    public static String getSystemProperty(String key2, String defaultValue) {
        try {
            return System.getProperty(key2, defaultValue);
        }
        catch (SecurityException e) {
            return defaultValue;
        }
    }

    @Override
    public int getPriority() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forEach(BiConsumer<String, String> action) {
        Object[] properties2;
        try {
            properties2 = System.getProperties();
        }
        catch (SecurityException e) {
            return;
        }
        Object[] objectArray = properties2;
        synchronized (properties2) {
            Object[] keySet = properties2.keySet().toArray();
            // ** MonitorExit[var4_5] (shouldn't be in output)
            for (Object key2 : keySet) {
                String keyStr = Objects.toString(key2, null);
                action.accept(keyStr, properties2.getProperty(keyStr));
            }
            return;
        }
    }

    @Override
    public CharSequence getNormalForm(Iterable<? extends CharSequence> tokens) {
        return PREFIX + PropertySource.Util.joinAsCamelCase(tokens);
    }

    @Override
    public Collection<String> getPropertyNames() {
        try {
            return System.getProperties().stringPropertyNames();
        }
        catch (SecurityException e) {
            return PropertySource.super.getPropertyNames();
        }
    }

    @Override
    public String getProperty(String key2) {
        try {
            return System.getProperty(key2);
        }
        catch (SecurityException e) {
            return PropertySource.super.getProperty(key2);
        }
    }

    @Override
    public boolean containsProperty(String key2) {
        return this.getProperty(key2) != null;
    }
}

