/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.slf4j;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.status.StatusLogger;
import org.slf4j.spi.MDCAdapter;

public class Log4jMDCAdapter
implements MDCAdapter {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final ThreadLocalMapOfStacks mapOfStacks = new ThreadLocalMapOfStacks();

    @Override
    public void put(String key2, String val) {
        ThreadContext.put(key2, val);
    }

    @Override
    public String get(String key2) {
        return ThreadContext.get(key2);
    }

    @Override
    public void remove(String key2) {
        ThreadContext.remove(key2);
    }

    @Override
    public void clear() {
        ThreadContext.clearMap();
    }

    @Override
    public Map<String, String> getCopyOfContextMap() {
        return ThreadContext.getContext();
    }

    @Override
    public void setContextMap(Map<String, String> map2) {
        ThreadContext.clearMap();
        ThreadContext.putAll(map2);
    }

    @Override
    public void pushByKey(String key2, String value2) {
        if (key2 == null) {
            ThreadContext.push(value2);
        } else {
            String oldValue = this.mapOfStacks.peekByKey(key2);
            if (!Objects.equals(ThreadContext.get(key2), oldValue)) {
                LOGGER.warn("The key {} was used in both the string and stack-valued MDC.", (Object)key2);
            }
            this.mapOfStacks.pushByKey(key2, value2);
            ThreadContext.put(key2, value2);
        }
    }

    @Override
    public String popByKey(String key2) {
        if (key2 == null) {
            return ThreadContext.getDepth() > 0 ? ThreadContext.pop() : null;
        }
        String value2 = this.mapOfStacks.popByKey(key2);
        if (!Objects.equals(ThreadContext.get(key2), value2)) {
            LOGGER.warn("The key {} was used in both the string and stack-valued MDC.", (Object)key2);
        }
        ThreadContext.put(key2, this.mapOfStacks.peekByKey(key2));
        return value2;
    }

    @Override
    public Deque<String> getCopyOfDequeByKey(String key2) {
        if (key2 == null) {
            ThreadContext.ContextStack stack = ThreadContext.getImmutableStack();
            ArrayDeque<String> copy2 = new ArrayDeque<String>(stack.size());
            stack.forEach(copy2::push);
            return copy2;
        }
        return this.mapOfStacks.getCopyOfDequeByKey(key2);
    }

    @Override
    public void clearDequeByKey(String key2) {
        if (key2 == null) {
            ThreadContext.clearStack();
        } else {
            this.mapOfStacks.clearByKey(key2);
            ThreadContext.put(key2, null);
        }
    }

    private static class ThreadLocalMapOfStacks {
        private final ThreadLocal<Map<String, Deque<String>>> tlMapOfStacks = ThreadLocal.withInitial(HashMap::new);

        private ThreadLocalMapOfStacks() {
        }

        public void pushByKey(String key2, String value2) {
            this.tlMapOfStacks.get().computeIfAbsent(key2, ignored -> new ArrayDeque()).push(value2);
        }

        public String popByKey(String key2) {
            Deque<String> deque = this.tlMapOfStacks.get().get(key2);
            return deque != null ? deque.poll() : null;
        }

        public Deque<String> getCopyOfDequeByKey(String key2) {
            Deque<String> deque = this.tlMapOfStacks.get().get(key2);
            return deque != null ? new ArrayDeque<String>(deque) : null;
        }

        public void clearByKey(String key2) {
            Deque<String> deque = this.tlMapOfStacks.get().get(key2);
            if (deque != null) {
                deque.clear();
            }
        }

        public String peekByKey(String key2) {
            Deque<String> deque = this.tlMapOfStacks.get().get(key2);
            return deque != null ? deque.peek() : null;
        }
    }
}

