/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.client;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.jetty.http2.FlowControlStrategy;
import org.eclipse.jetty.http2.HTTP2Connection;
import org.eclipse.jetty.http2.ISession;
import org.eclipse.jetty.http2.api.Session;
import org.eclipse.jetty.http2.client.HTTP2Client;
import org.eclipse.jetty.http2.client.HTTP2ClientSession;
import org.eclipse.jetty.http2.frames.PrefaceFrame;
import org.eclipse.jetty.http2.frames.SettingsFrame;
import org.eclipse.jetty.http2.frames.WindowUpdateFrame;
import org.eclipse.jetty.http2.generator.Generator;
import org.eclipse.jetty.http2.parser.Parser;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.thread.Invocable;
import org.eclipse.jetty.util.thread.Scheduler;

public class HTTP2ClientConnectionFactory
implements ClientConnectionFactory {
    public static final String CLIENT_CONTEXT_KEY = "http2.client";
    public static final String BYTE_BUFFER_POOL_CONTEXT_KEY = "http2.client.byteBufferPool";
    public static final String EXECUTOR_CONTEXT_KEY = "http2.client.executor";
    public static final String SCHEDULER_CONTEXT_KEY = "http2.client.scheduler";
    public static final String SESSION_LISTENER_CONTEXT_KEY = "http2.client.sessionListener";
    public static final String SESSION_PROMISE_CONTEXT_KEY = "http2.client.sessionPromise";
    private final Connection.Listener connectionListener = new ConnectionListener();

    @Override
    public Connection newConnection(EndPoint endPoint, Map<String, Object> context) {
        HTTP2Client client2 = (HTTP2Client)context.get(CLIENT_CONTEXT_KEY);
        ByteBufferPool byteBufferPool = client2.getByteBufferPool();
        Executor executor = client2.getExecutor();
        Scheduler scheduler = client2.getScheduler();
        Session.Listener listener = (Session.Listener)context.get(SESSION_LISTENER_CONTEXT_KEY);
        Promise sessionPromise = (Promise)context.get(SESSION_PROMISE_CONTEXT_KEY);
        Generator generator = new Generator(byteBufferPool, client2.getMaxHeaderBlockFragment());
        FlowControlStrategy flowControl = client2.getFlowControlStrategyFactory().newFlowControlStrategy();
        Parser parser = new Parser(byteBufferPool, client2.getMaxResponseHeadersSize());
        parser.setMaxFrameSize(client2.getMaxFrameSize());
        parser.setMaxSettingsKeys(client2.getMaxSettingsKeys());
        HTTP2ClientSession session2 = new HTTP2ClientSession(scheduler, endPoint, parser, generator, listener, flowControl);
        session2.setMaxRemoteStreams(client2.getMaxConcurrentPushedStreams());
        session2.setMaxEncoderTableCapacity(client2.getMaxEncoderTableCapacity());
        long streamIdleTimeout = client2.getStreamIdleTimeout();
        if (streamIdleTimeout > 0L) {
            session2.setStreamIdleTimeout(streamIdleTimeout);
        }
        HTTP2ClientConnection connection = new HTTP2ClientConnection(client2, byteBufferPool, executor, endPoint, session2, client2.getInputBufferSize(), sessionPromise, listener);
        connection.addListener(this.connectionListener);
        parser.init(connection.wrapParserListener(session2));
        return this.customize(connection, context);
    }

    private static class ConnectionListener
    implements Connection.Listener {
        private ConnectionListener() {
        }

        @Override
        public void onOpened(Connection connection) {
            HTTP2ClientConnection http2Connection = (HTTP2ClientConnection)connection;
            http2Connection.client.addManaged((LifeCycle)((Object)http2Connection.getSession()));
        }

        @Override
        public void onClosed(Connection connection) {
            HTTP2ClientConnection http2Connection = (HTTP2ClientConnection)connection;
            http2Connection.client.removeBean(http2Connection.getSession());
        }
    }

    private static class HTTP2ClientConnection
    extends HTTP2Connection
    implements Callback {
        private final HTTP2Client client;
        private final Promise<Session> promise;
        private final Session.Listener listener;

        private HTTP2ClientConnection(HTTP2Client client2, ByteBufferPool byteBufferPool, Executor executor, EndPoint endpoint, ISession session2, int bufferSize, Promise<Session> promise, Session.Listener listener) {
            super(byteBufferPool, executor, endpoint, session2, bufferSize);
            this.client = client2;
            this.promise = promise;
            this.listener = listener;
        }

        @Override
        public void onOpen() {
            Map<Integer, Integer> settings = this.listener.onPreface(this.getSession());
            if (settings == null) {
                settings = new HashMap<Integer, Integer>();
            }
            settings.compute(1, (k, v) -> {
                if (v == null && (v = Integer.valueOf(this.client.getMaxDecoderTableCapacity())) == 4096) {
                    v = null;
                }
                return v;
            });
            settings.computeIfAbsent(3, k -> this.client.getMaxConcurrentPushedStreams());
            settings.compute(4, (k, v) -> {
                if (v == null && (v = Integer.valueOf(this.client.getInitialStreamRecvWindow())) == 65535) {
                    v = null;
                }
                return v;
            });
            settings.compute(5, (k, v) -> {
                if (v == null && (v = Integer.valueOf(this.client.getMaxFrameSize())) == 16384) {
                    v = null;
                }
                return v;
            });
            settings.compute(6, (k, v) -> {
                if (v == null && (v = Integer.valueOf(this.client.getMaxResponseHeadersSize())) <= 0) {
                    v = null;
                }
                return v;
            });
            PrefaceFrame prefaceFrame = new PrefaceFrame();
            SettingsFrame settingsFrame = new SettingsFrame(settings, false);
            ISession session2 = this.getSession();
            int windowDelta = this.client.getInitialSessionRecvWindow() - 65535;
            session2.updateRecvWindow(windowDelta);
            if (windowDelta > 0) {
                session2.frames(null, Arrays.asList(prefaceFrame, settingsFrame, new WindowUpdateFrame(0, windowDelta)), this);
            } else {
                session2.frames(null, Arrays.asList(prefaceFrame, settingsFrame), this);
            }
        }

        @Override
        public void succeeded() {
            super.onOpen();
            this.promise.succeeded(this.getSession());
            this.produce();
        }

        @Override
        public void failed(Throwable x) {
            this.close();
            this.promise.failed(x);
        }

        @Override
        public Invocable.InvocationType getInvocationType() {
            return Invocable.InvocationType.NON_BLOCKING;
        }
    }
}

