/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.component;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Stream;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;

@ManagedObject(value="Dumpable Object")
public interface Dumpable {
    public static final String KEY = "key: +- bean, += managed, +~ unmanaged, +? auto, +: iterable, +] array, +@ map, +> undefined";

    @ManagedOperation(value="Dump the nested Object state as a String", impact="INFO")
    default public String dump() {
        return Dumpable.dump(this);
    }

    public void dump(Appendable var1, String var2) throws IOException;

    public static String dump(Dumpable dumpable) {
        StringBuilder b = new StringBuilder();
        try {
            dumpable.dump(b, "");
        }
        catch (IOException e) {
            b.append(e.toString());
        }
        b.append(KEY);
        return b.toString();
    }

    default public String dumpSelf() {
        return this.toString();
    }

    public static void dumpObject(Appendable out2, Object o) throws IOException {
        try {
            String s2;
            if (o == null) {
                s2 = "null";
            } else if (o instanceof Dumpable) {
                s2 = ((Dumpable)o).dumpSelf();
                s2 = StringUtil.replace(s2, "\r\n", "|");
                s2 = StringUtil.replace(s2, '\n', '|');
            } else if (o instanceof Collection) {
                s2 = String.format("%s@%x(size=%d)", o.getClass().getName(), o.hashCode(), ((Collection)o).size());
            } else if (o.getClass().isArray()) {
                s2 = String.format("%s@%x[size=%d]", o.getClass().getComponentType(), o.hashCode(), Array.getLength(o));
            } else if (o instanceof Map) {
                s2 = String.format("%s@%x{size=%d}", o.getClass().getName(), o.hashCode(), ((Map)o).size());
            } else {
                s2 = String.valueOf(o);
                s2 = StringUtil.replace(s2, "\r\n", "|");
                s2 = StringUtil.replace(s2, '\n', '|');
            }
            if (o instanceof LifeCycle) {
                out2.append(s2).append(" - ").append(AbstractLifeCycle.getState((LifeCycle)o)).append("\n");
            } else {
                out2.append(s2).append("\n");
            }
        }
        catch (Throwable ex) {
            out2.append("=> ").append(ex.toString()).append("\n");
        }
    }

    public static void dumpObjects(Appendable out2, String indent2, Object object, Object ... extraChildren) throws IOException {
        int extras;
        Dumpable.dumpObject(out2, object);
        int n = extras = extraChildren == null ? 0 : extraChildren.length;
        if (object instanceof Stream) {
            object = ((Stream)object).toArray();
        }
        if (object instanceof Array) {
            object = Arrays.asList(object);
        }
        if (object instanceof Container) {
            Dumpable.dumpContainer(out2, indent2, (Container)object, extras == 0);
        }
        if (object instanceof Iterable) {
            Dumpable.dumpIterable(out2, indent2, (Iterable)object, extras == 0);
        } else if (object instanceof Map) {
            Dumpable.dumpMapEntries(out2, indent2, (Map)object, extras == 0);
        }
        if (extras == 0) {
            return;
        }
        int i = 0;
        for (Object item : extraChildren) {
            String nextIndent = indent2 + (++i < extras ? "|  " : "   ");
            out2.append(indent2).append("+> ");
            if (item instanceof Dumpable) {
                ((Dumpable)item).dump(out2, nextIndent);
                continue;
            }
            Dumpable.dumpObjects(out2, nextIndent, item, new Object[0]);
        }
    }

    public static void dumpContainer(Appendable out2, String indent2, Container object, boolean last2) throws IOException {
        Container container = object;
        ContainerLifeCycle containerLifeCycle = container instanceof ContainerLifeCycle ? (ContainerLifeCycle)container : null;
        Iterator<Object> i = container.getBeans().iterator();
        while (i.hasNext()) {
            Object bean = i.next();
            if (container instanceof DumpableContainer && !((DumpableContainer)((Object)container)).isDumpable(bean)) continue;
            String nextIndent = indent2 + (i.hasNext() || !last2 ? "|  " : "   ");
            if (bean instanceof LifeCycle) {
                if (container.isManaged(bean)) {
                    out2.append(indent2).append("+= ");
                    if (bean instanceof Dumpable) {
                        ((Dumpable)bean).dump(out2, nextIndent);
                        continue;
                    }
                    Dumpable.dumpObjects(out2, nextIndent, bean, new Object[0]);
                    continue;
                }
                if (containerLifeCycle != null && containerLifeCycle.isAuto(bean)) {
                    out2.append(indent2).append("+? ");
                    if (bean instanceof Dumpable) {
                        ((Dumpable)bean).dump(out2, nextIndent);
                        continue;
                    }
                    Dumpable.dumpObjects(out2, nextIndent, bean, new Object[0]);
                    continue;
                }
                out2.append(indent2).append("+~ ");
                Dumpable.dumpObject(out2, bean);
                continue;
            }
            if (containerLifeCycle != null && containerLifeCycle.isUnmanaged(bean)) {
                out2.append(indent2).append("+~ ");
                Dumpable.dumpObject(out2, bean);
                continue;
            }
            out2.append(indent2).append("+- ");
            if (bean instanceof Dumpable) {
                ((Dumpable)bean).dump(out2, nextIndent);
                continue;
            }
            Dumpable.dumpObjects(out2, nextIndent, bean, new Object[0]);
        }
    }

    public static void dumpIterable(Appendable out2, String indent2, Iterable<?> iterable, boolean last2) throws IOException {
        Iterator<?> i = iterable.iterator();
        while (i.hasNext()) {
            Object item = i.next();
            String nextIndent = indent2 + (i.hasNext() || !last2 ? "|  " : "   ");
            out2.append(indent2).append("+: ");
            if (item instanceof Dumpable) {
                ((Dumpable)item).dump(out2, nextIndent);
                continue;
            }
            Dumpable.dumpObjects(out2, nextIndent, item, new Object[0]);
        }
    }

    public static void dumpMapEntries(Appendable out2, String indent2, Map<?, ?> map2, boolean last2) throws IOException {
        Iterator<Map.Entry<?, ?>> i = map2.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<?, ?> entry = i.next();
            String nextIndent = indent2 + (i.hasNext() || !last2 ? "|  " : "   ");
            out2.append(indent2).append("+@ ").append(String.valueOf(entry.getKey())).append(" = ");
            Object item = entry.getValue();
            if (item instanceof Dumpable) {
                ((Dumpable)item).dump(out2, nextIndent);
                continue;
            }
            Dumpable.dumpObjects(out2, nextIndent, item, new Object[0]);
        }
    }

    public static Dumpable named(String name, Object object) {
        return (out2, indent2) -> {
            out2.append(name).append(": ");
            Dumpable.dumpObjects(out2, indent2, object, new Object[0]);
        };
    }

    public static interface DumpableContainer
    extends Dumpable {
        default public boolean isDumpable(Object o) {
            return true;
        }
    }
}

