/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.mqttv5.client.internal;

import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.eclipse.paho.mqttv5.client.internal.ClientComms;
import org.eclipse.paho.mqttv5.client.internal.ClientState;
import org.eclipse.paho.mqttv5.client.internal.CommsTokenStore;
import org.eclipse.paho.mqttv5.client.logging.Logger;
import org.eclipse.paho.mqttv5.client.logging.LoggerFactory;
import org.eclipse.paho.mqttv5.client.wire.MqttOutputStream;
import org.eclipse.paho.mqttv5.common.MqttException;
import org.eclipse.paho.mqttv5.common.packet.MqttAck;
import org.eclipse.paho.mqttv5.common.packet.MqttDisconnect;
import org.eclipse.paho.mqttv5.common.packet.MqttWireMessage;

public class CommsSender
implements Runnable {
    private static final String CLASS_NAME = CommsSender.class.getName();
    private Logger log = LoggerFactory.getLogger("org.eclipse.paho.mqttv5.client.internal.nls.logcat", CLASS_NAME);
    private State current_state = State.STOPPED;
    private State target_state = State.STOPPED;
    private final Object lifecycle = new Object();
    private Thread sendThread = null;
    private String threadName;
    private Future<?> senderFuture;
    private ClientState clientState = null;
    private MqttOutputStream out;
    private ClientComms clientComms = null;
    private CommsTokenStore tokenStore = null;

    public CommsSender(ClientComms clientComms, ClientState clientState, CommsTokenStore tokenStore, OutputStream out2) {
        this.out = new MqttOutputStream(clientState, out2, clientComms.getClient().getClientId());
        this.clientComms = clientComms;
        this.clientState = clientState;
        this.tokenStore = tokenStore;
        this.log.setResourceName(clientComms.getClient().getClientId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void start(String threadName, ExecutorService executorService) {
        this.threadName = threadName;
        var3_3 = this.lifecycle;
        synchronized (var3_3) {
            if (this.current_state == State.STOPPED && this.target_state == State.STOPPED) {
                this.target_state = State.RUNNING;
                if (executorService == null) {
                    new Thread(this).start();
                } else {
                    this.senderFuture = executorService.submit(this);
                }
            }
            // MONITOREXIT @DISABLED, blocks:[0, 2] lbl11 : MonitorExitStatement: MONITOREXIT : var3_3
            if (true) ** GOTO lbl20
        }
        do {
            try {
                Thread.sleep(100L);
            }
            catch (Exception v1) {}
lbl20:
            // 3 sources

        } while (!this.isRunning());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void stop() {
        if (!this.isRunning()) {
            return;
        }
        var1_1 = this.lifecycle;
        synchronized (var1_1) {
            if (this.senderFuture != null) {
                this.senderFuture.cancel(true);
            }
            this.log.fine(CommsSender.CLASS_NAME, "stop", "800");
            if (this.isRunning()) {
                this.target_state = State.STOPPED;
                this.clientState.notifyQueueLock();
            }
            // MONITOREXIT @DISABLED, blocks:[0, 2] lbl13 : MonitorExitStatement: MONITOREXIT : var1_1
            if (true) ** GOTO lbl23
        }
        do {
            try {
                Thread.sleep(100L);
            }
            catch (Exception v1) {}
            this.clientState.notifyQueueLock();
lbl23:
            // 2 sources

        } while (this.isRunning());
        this.log.fine(CommsSender.CLASS_NAME, "stop", "801");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        this.sendThread = Thread.currentThread();
        this.sendThread.setName(this.threadName);
        message = null;
        var2_2 = this.lifecycle;
        synchronized (var2_2) {
            this.current_state = State.RUNNING;
        }
        try {
            var3_3 = this.lifecycle;
            synchronized (var3_3) {
                my_target = this.target_state;
                // MONITOREXIT @DISABLED, blocks:[1, 2, 11] lbl18 : MonitorExitStatement: MONITOREXIT : var3_3
                if (true) ** GOTO lbl67
            }
            do {
                block31: {
                    try {
                        message = this.clientState.get();
                        if (message != null) {
                            this.log.fine(CommsSender.CLASS_NAME, "run", "802", new Object[]{message.getKey(), message});
                            if (message instanceof MqttAck) {
                                this.out.write(message);
                                this.out.flush();
                                break block31;
                            }
                            token = this.tokenStore.getToken(message);
                            if (token == null) break block31;
                            var4_6 = token;
                            synchronized (var4_6) {
                                block32: {
                                    this.out.write(message);
                                    try {
                                        this.out.flush();
                                    }
                                    catch (IOException ex) {
                                        if (message instanceof MqttDisconnect) break block32;
                                        throw ex;
                                    }
                                }
                                this.clientState.notifySent(message);
                                break block31;
                            }
                        }
                        this.log.fine(CommsSender.CLASS_NAME, "run", "803");
                        token = this.lifecycle;
                        synchronized (token) {
                            this.target_state = State.STOPPED;
                        }
                    }
                    catch (MqttException me) {
                        this.handleRunException(message, me);
                    }
                    catch (Exception ex) {
                        this.handleRunException(message, ex);
                    }
                }
                var3_3 = this.lifecycle;
                synchronized (var3_3) {
                    my_target = this.target_state;
                }
lbl67:
                // 2 sources

            } while (my_target == State.RUNNING && this.out != null);
        }
        catch (Throwable var6_8) {
            var7_9 = this.lifecycle;
            synchronized (var7_9) {
                this.current_state = State.STOPPED;
                this.sendThread = null;
            }
            throw var6_8;
        }
        var7_10 = this.lifecycle;
        synchronized (var7_10) {
            this.current_state = State.STOPPED;
            this.sendThread = null;
        }
        this.log.fine(CommsSender.CLASS_NAME, "run", "805");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRunException(MqttWireMessage message, Exception ex) {
        this.log.severe(CLASS_NAME, "handleRunException", "804", null, ex);
        MqttException mex = !(ex instanceof MqttException) ? new MqttException(32109, (Throwable)ex) : (MqttException)ex;
        Object object = this.lifecycle;
        synchronized (object) {
            this.target_state = State.STOPPED;
        }
        this.clientComms.shutdownConnection(null, mex, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        boolean result2;
        Object object = this.lifecycle;
        synchronized (object) {
            result2 = this.current_state == State.RUNNING && this.target_state == State.RUNNING;
        }
        return result2;
    }

    private static enum State {
        STOPPED,
        RUNNING,
        STARTING;

    }
}

