/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.mqttv5.client.security;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.eclipse.paho.mqttv5.client.logging.Logger;
import org.eclipse.paho.mqttv5.client.security.SimpleBase64Encoder;
import org.eclipse.paho.mqttv5.common.MqttSecurityException;

public class SSLSocketFactoryFactory {
    private static final String CLASS_NAME = "org.eclipse.paho.mqttv5.client.internal.security.SSLSocketFactoryFactory";
    public static final String SSLPROTOCOL = "com.ibm.ssl.protocol";
    public static final String JSSEPROVIDER = "com.ibm.ssl.contextProvider";
    public static final String KEYSTORE = "com.ibm.ssl.keyStore";
    public static final String KEYSTOREPWD = "com.ibm.ssl.keyStorePassword";
    public static final String KEYSTORETYPE = "com.ibm.ssl.keyStoreType";
    public static final String KEYSTOREPROVIDER = "com.ibm.ssl.keyStoreProvider";
    public static final String KEYSTOREMGR = "com.ibm.ssl.keyManager";
    public static final String TRUSTSTORE = "com.ibm.ssl.trustStore";
    public static final String TRUSTSTOREPWD = "com.ibm.ssl.trustStorePassword";
    public static final String TRUSTSTORETYPE = "com.ibm.ssl.trustStoreType";
    public static final String TRUSTSTOREPROVIDER = "com.ibm.ssl.trustStoreProvider";
    public static final String TRUSTSTOREMGR = "com.ibm.ssl.trustManager";
    public static final String CIPHERSUITES = "com.ibm.ssl.enabledCipherSuites";
    public static final String CLIENTAUTH = "com.ibm.ssl.clientAuthentication";
    public static final String SYSKEYSTORE = "javax.net.ssl.keyStore";
    public static final String SYSKEYSTORETYPE = "javax.net.ssl.keyStoreType";
    public static final String SYSKEYSTOREPWD = "javax.net.ssl.keyStorePassword";
    public static final String SYSTRUSTSTORE = "javax.net.ssl.trustStore";
    public static final String SYSTRUSTSTORETYPE = "javax.net.ssl.trustStoreType";
    public static final String SYSTRUSTSTOREPWD = "javax.net.ssl.trustStorePassword";
    public static final String SYSKEYMGRALGO = "ssl.KeyManagerFactory.algorithm";
    public static final String SYSTRUSTMGRALGO = "ssl.TrustManagerFactory.algorithm";
    public static final String DEFAULT_PROTOCOL = "TLS";
    private static final String[] propertyKeys = new String[]{"com.ibm.ssl.protocol", "com.ibm.ssl.contextProvider", "com.ibm.ssl.keyStore", "com.ibm.ssl.keyStorePassword", "com.ibm.ssl.keyStoreType", "com.ibm.ssl.keyStoreProvider", "com.ibm.ssl.keyManager", "com.ibm.ssl.trustStore", "com.ibm.ssl.trustStorePassword", "com.ibm.ssl.trustStoreType", "com.ibm.ssl.trustStoreProvider", "com.ibm.ssl.trustManager", "com.ibm.ssl.enabledCipherSuites", "com.ibm.ssl.clientAuthentication"};
    private Hashtable<String, Properties> configs = new Hashtable();
    private Properties defaultProperties;
    private static final byte[] key = new byte[]{-99, -89, -39, -128, 5, -72, -119, -100};
    private static final String xorTag = "{xor}";
    private Logger logger = null;

    public static boolean isSupportedOnJVM() throws LinkageError, ExceptionInInitializerError {
        String requiredClassname = "javax.net.ssl.SSLServerSocketFactory";
        try {
            Class.forName(requiredClassname);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        return true;
    }

    public SSLSocketFactoryFactory() {
    }

    public SSLSocketFactoryFactory(Logger logger) {
        this();
        this.logger = logger;
    }

    private boolean keyValid(String key2) {
        int i = 0;
        while (i < propertyKeys.length) {
            if (propertyKeys[i].equals(key2)) break;
            ++i;
        }
        return i < propertyKeys.length;
    }

    private void checkPropertyKeys(Properties properties2) throws IllegalArgumentException {
        Set<Object> keys2 = properties2.keySet();
        for (String string : keys2) {
            if (this.keyValid(string)) continue;
            throw new IllegalArgumentException(String.valueOf(string) + " is not a valid IBM SSL property key.");
        }
    }

    public static char[] toChar(byte[] b) {
        if (b == null) {
            return null;
        }
        char[] c = new char[b.length / 2];
        int i = 0;
        int j = 0;
        while (i < b.length) {
            c[j++] = (char)((b[i++] & 0xFF) + ((b[i++] & 0xFF) << 8));
        }
        return c;
    }

    public static byte[] toByte(char[] c) {
        if (c == null) {
            return null;
        }
        byte[] b = new byte[c.length * 2];
        int i = 0;
        int j = 0;
        while (j < c.length) {
            b[i++] = (byte)(c[j] & 0xFF);
            b[i++] = (byte)(c[j++] >> 8 & 0xFF);
        }
        return b;
    }

    public static String obfuscate(char[] password) {
        if (password == null) {
            return null;
        }
        byte[] bytes = SSLSocketFactoryFactory.toByte(password);
        int i = 0;
        while (i < bytes.length) {
            bytes[i] = (byte)((bytes[i] ^ key[i % key.length]) & 0xFF);
            ++i;
        }
        String encryptedValue = xorTag + new String(SimpleBase64Encoder.encode(bytes));
        return encryptedValue;
    }

    public static char[] deObfuscate(String ePassword) {
        if (ePassword == null) {
            return null;
        }
        byte[] bytes = null;
        try {
            bytes = SimpleBase64Encoder.decode(ePassword.substring(xorTag.length()));
        }
        catch (Exception exception) {
            return null;
        }
        int i = 0;
        while (i < bytes.length) {
            bytes[i] = (byte)((bytes[i] ^ key[i % key.length]) & 0xFF);
            ++i;
        }
        return SSLSocketFactoryFactory.toChar(bytes);
    }

    public static String packCipherSuites(String[] ciphers) {
        String cipherSet = null;
        if (ciphers != null) {
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < ciphers.length) {
                buf.append(ciphers[i]);
                if (i < ciphers.length - 1) {
                    buf.append(',');
                }
                ++i;
            }
            cipherSet = buf.toString();
        }
        return cipherSet;
    }

    public static String[] unpackCipherSuites(String ciphers) {
        if (ciphers == null) {
            return null;
        }
        Vector<String> c = new Vector<String>();
        int i = ciphers.indexOf(44);
        int j = 0;
        while (i > -1) {
            c.add(ciphers.substring(j, i));
            j = i + 1;
            i = ciphers.indexOf(44, j);
        }
        c.add(ciphers.substring(j));
        String[] s2 = new String[c.size()];
        c.toArray(s2);
        return s2;
    }

    private void convertPassword(Properties p) {
        String epw;
        String pw = p.getProperty(KEYSTOREPWD);
        if (pw != null && !pw.startsWith(xorTag)) {
            epw = SSLSocketFactoryFactory.obfuscate(pw.toCharArray());
            p.put(KEYSTOREPWD, epw);
        }
        if ((pw = p.getProperty(TRUSTSTOREPWD)) != null && !pw.startsWith(xorTag)) {
            epw = SSLSocketFactoryFactory.obfuscate(pw.toCharArray());
            p.put(TRUSTSTOREPWD, epw);
        }
    }

    public void initialize(Properties props, String configID) throws IllegalArgumentException {
        this.checkPropertyKeys(props);
        Properties p = new Properties();
        p.putAll((Map<?, ?>)props);
        this.convertPassword(p);
        if (configID != null) {
            this.configs.put(configID, p);
        } else {
            this.defaultProperties = p;
        }
    }

    public void merge(Properties props, String configID) throws IllegalArgumentException {
        this.checkPropertyKeys(props);
        Properties p = this.defaultProperties;
        if (configID != null) {
            p = this.configs.get(configID);
        }
        if (p == null) {
            p = new Properties();
        }
        this.convertPassword(props);
        p.putAll((Map<?, ?>)props);
        if (configID != null) {
            this.configs.put(configID, p);
        } else {
            this.defaultProperties = p;
        }
    }

    public boolean remove(String configID) {
        boolean res = false;
        if (configID != null) {
            res = this.configs.remove(configID) != null;
        } else if (this.defaultProperties != null) {
            res = true;
            this.defaultProperties = null;
        }
        return res;
    }

    public Properties getConfiguration(String configID) {
        return configID == null ? this.defaultProperties : this.configs.get(configID);
    }

    private String getProperty(String configID, String ibmKey, String sysProperty) {
        String res = null;
        res = this.getPropertyFromConfig(configID, ibmKey);
        if (res != null) {
            return res;
        }
        if (sysProperty != null) {
            res = System.getProperty(sysProperty);
        }
        return res;
    }

    private String getPropertyFromConfig(String configID, String ibmKey) {
        String res = null;
        Properties p = null;
        if (configID != null) {
            p = this.configs.get(configID);
        }
        if (p != null && (res = p.getProperty(ibmKey)) != null) {
            return res;
        }
        p = this.defaultProperties;
        if (p != null && (res = p.getProperty(ibmKey)) != null) {
            return res;
        }
        return res;
    }

    public String getSSLProtocol(String configID) {
        return this.getProperty(configID, SSLPROTOCOL, null);
    }

    public String getJSSEProvider(String configID) {
        return this.getProperty(configID, JSSEPROVIDER, null);
    }

    public String getKeyStore(String configID) {
        String ibmKey = KEYSTORE;
        String sysProperty = SYSKEYSTORE;
        String res = null;
        res = this.getPropertyFromConfig(configID, ibmKey);
        if (res != null) {
            return res;
        }
        if (sysProperty != null) {
            res = System.getProperty(sysProperty);
        }
        return res;
    }

    public char[] getKeyStorePassword(String configID) {
        String pw = this.getProperty(configID, KEYSTOREPWD, SYSKEYSTOREPWD);
        char[] r = null;
        if (pw != null) {
            r = pw.startsWith(xorTag) ? SSLSocketFactoryFactory.deObfuscate(pw) : pw.toCharArray();
        }
        return r;
    }

    public String getKeyStoreType(String configID) {
        return this.getProperty(configID, KEYSTORETYPE, SYSKEYSTORETYPE);
    }

    public String getKeyStoreProvider(String configID) {
        return this.getProperty(configID, KEYSTOREPROVIDER, null);
    }

    public String getKeyManager(String configID) {
        return this.getProperty(configID, KEYSTOREMGR, SYSKEYMGRALGO);
    }

    public String getTrustStore(String configID) {
        return this.getProperty(configID, TRUSTSTORE, SYSTRUSTSTORE);
    }

    public char[] getTrustStorePassword(String configID) {
        String pw = this.getProperty(configID, TRUSTSTOREPWD, SYSTRUSTSTOREPWD);
        char[] r = null;
        if (pw != null) {
            r = pw.startsWith(xorTag) ? SSLSocketFactoryFactory.deObfuscate(pw) : pw.toCharArray();
        }
        return r;
    }

    public String getTrustStoreType(String configID) {
        return this.getProperty(configID, TRUSTSTORETYPE, null);
    }

    public String getTrustStoreProvider(String configID) {
        return this.getProperty(configID, TRUSTSTOREPROVIDER, null);
    }

    public String getTrustManager(String configID) {
        return this.getProperty(configID, TRUSTSTOREMGR, SYSTRUSTMGRALGO);
    }

    public String[] getEnabledCipherSuites(String configID) {
        String ciphers = this.getProperty(configID, CIPHERSUITES, null);
        String[] res = SSLSocketFactoryFactory.unpackCipherSuites(ciphers);
        return res;
    }

    public boolean getClientAuthentication(String configID) {
        String auth = this.getProperty(configID, CLIENTAUTH, null);
        boolean res = false;
        if (auth != null) {
            res = Boolean.valueOf(auth);
        }
        return res;
    }

    private SSLContext getSSLContext(String configID) throws MqttSecurityException {
        SSLContext ctx = null;
        String protocol = this.getSSLProtocol(configID);
        if (protocol == null) {
            protocol = DEFAULT_PROTOCOL;
        }
        if (this.logger != null) {
            this.logger.fine(CLASS_NAME, "getSSLContext", "12000", new Object[]{configID != null ? configID : "null (broker defaults)", protocol});
        }
        String provider2 = this.getJSSEProvider(configID);
        try {
            String trustStoreType;
            ctx = provider2 == null ? SSLContext.getInstance(protocol) : SSLContext.getInstance(protocol, provider2);
            if (this.logger != null) {
                this.logger.fine(CLASS_NAME, "getSSLContext", "12001", new Object[]{configID != null ? configID : "null (broker defaults)", ctx.getProvider().getName()});
            }
            String keyStoreName = this.getProperty(configID, KEYSTORE, null);
            KeyStore keyStore = null;
            KeyManagerFactory keyMgrFact = null;
            KeyManager[] keyMgr = null;
            if (keyStore == null) {
                String keyStoreType;
                if (keyStoreName == null) {
                    keyStoreName = this.getProperty(configID, KEYSTORE, SYSKEYSTORE);
                }
                if (this.logger != null) {
                    this.logger.fine(CLASS_NAME, "getSSLContext", "12004", new Object[]{configID != null ? configID : "null (broker defaults)", keyStoreName != null ? keyStoreName : "null"});
                }
                char[] keyStorePwd = this.getKeyStorePassword(configID);
                if (this.logger != null) {
                    this.logger.fine(CLASS_NAME, "getSSLContext", "12005", new Object[]{configID != null ? configID : "null (broker defaults)", keyStorePwd != null ? SSLSocketFactoryFactory.obfuscate(keyStorePwd) : "null"});
                }
                if ((keyStoreType = this.getKeyStoreType(configID)) == null) {
                    keyStoreType = KeyStore.getDefaultType();
                }
                if (this.logger != null) {
                    this.logger.fine(CLASS_NAME, "getSSLContext", "12006", new Object[]{configID != null ? configID : "null (broker defaults)", keyStoreType != null ? keyStoreType : "null"});
                }
                String keyMgrAlgo = KeyManagerFactory.getDefaultAlgorithm();
                String keyMgrProvider = this.getKeyStoreProvider(configID);
                String keyManager = this.getKeyManager(configID);
                if (keyManager != null) {
                    keyMgrAlgo = keyManager;
                }
                if (keyStoreName != null && keyStoreType != null && keyMgrAlgo != null) {
                    try {
                        keyStore = KeyStore.getInstance(keyStoreType);
                        keyStore.load(new FileInputStream(keyStoreName), keyStorePwd);
                        keyMgrFact = keyMgrProvider != null ? KeyManagerFactory.getInstance(keyMgrAlgo, keyMgrProvider) : KeyManagerFactory.getInstance(keyMgrAlgo);
                        if (this.logger != null) {
                            this.logger.fine(CLASS_NAME, "getSSLContext", "12010", new Object[]{configID != null ? configID : "null (broker defaults)", keyMgrAlgo != null ? keyMgrAlgo : "null"});
                            this.logger.fine(CLASS_NAME, "getSSLContext", "12009", new Object[]{configID != null ? configID : "null (broker defaults)", keyMgrFact.getProvider().getName()});
                        }
                        keyMgrFact.init(keyStore, keyStorePwd);
                        keyMgr = keyMgrFact.getKeyManagers();
                    }
                    catch (KeyStoreException e) {
                        throw new MqttSecurityException(e);
                    }
                    catch (CertificateException e) {
                        throw new MqttSecurityException(e);
                    }
                    catch (FileNotFoundException e) {
                        throw new MqttSecurityException(e);
                    }
                    catch (IOException e) {
                        throw new MqttSecurityException(e);
                    }
                    catch (UnrecoverableKeyException e) {
                        throw new MqttSecurityException(e);
                    }
                }
            }
            String trustStoreName = this.getTrustStore(configID);
            if (this.logger != null) {
                this.logger.fine(CLASS_NAME, "getSSLContext", "12011", new Object[]{configID != null ? configID : "null (broker defaults)", trustStoreName != null ? trustStoreName : "null"});
            }
            KeyStore trustStore = null;
            TrustManagerFactory trustMgrFact = null;
            TrustManager[] trustMgr = null;
            char[] trustStorePwd = this.getTrustStorePassword(configID);
            if (this.logger != null) {
                this.logger.fine(CLASS_NAME, "getSSLContext", "12012", new Object[]{configID != null ? configID : "null (broker defaults)", trustStorePwd != null ? SSLSocketFactoryFactory.obfuscate(trustStorePwd) : "null"});
            }
            if ((trustStoreType = this.getTrustStoreType(configID)) == null) {
                trustStoreType = KeyStore.getDefaultType();
            }
            if (this.logger != null) {
                this.logger.fine(CLASS_NAME, "getSSLContext", "12013", new Object[]{configID != null ? configID : "null (broker defaults)", trustStoreType != null ? trustStoreType : "null"});
            }
            String trustMgrAlgo = TrustManagerFactory.getDefaultAlgorithm();
            String trustMgrProvider = this.getTrustStoreProvider(configID);
            String trustManager = this.getTrustManager(configID);
            if (trustManager != null) {
                trustMgrAlgo = trustManager;
            }
            if (trustStoreName != null && trustStoreType != null && trustMgrAlgo != null) {
                try {
                    trustStore = KeyStore.getInstance(trustStoreType);
                    trustStore.load(new FileInputStream(trustStoreName), trustStorePwd);
                    trustMgrFact = trustMgrProvider != null ? TrustManagerFactory.getInstance(trustMgrAlgo, trustMgrProvider) : TrustManagerFactory.getInstance(trustMgrAlgo);
                    if (this.logger != null) {
                        this.logger.fine(CLASS_NAME, "getSSLContext", "12017", new Object[]{configID != null ? configID : "null (broker defaults)", trustMgrAlgo != null ? trustMgrAlgo : "null"});
                        this.logger.fine(CLASS_NAME, "getSSLContext", "12016", new Object[]{configID != null ? configID : "null (broker defaults)", trustMgrFact.getProvider().getName()});
                    }
                    trustMgrFact.init(trustStore);
                    trustMgr = trustMgrFact.getTrustManagers();
                }
                catch (KeyStoreException e) {
                    throw new MqttSecurityException(e);
                }
                catch (CertificateException e) {
                    throw new MqttSecurityException(e);
                }
                catch (FileNotFoundException e) {
                    throw new MqttSecurityException(e);
                }
                catch (IOException e) {
                    throw new MqttSecurityException(e);
                }
            }
            ctx.init(keyMgr, trustMgr, null);
        }
        catch (NoSuchAlgorithmException e) {
            throw new MqttSecurityException(e);
        }
        catch (NoSuchProviderException e) {
            throw new MqttSecurityException(e);
        }
        catch (KeyManagementException e) {
            throw new MqttSecurityException(e);
        }
        return ctx;
    }

    public SSLSocketFactory createSocketFactory(String configID) throws MqttSecurityException {
        SSLContext ctx = this.getSSLContext(configID);
        if (this.logger != null) {
            this.logger.fine(CLASS_NAME, "createSocketFactory", "12020", new Object[]{configID != null ? configID : "null (broker defaults)", this.getEnabledCipherSuites(configID) != null ? this.getProperty(configID, CIPHERSUITES, null) : "null (using platform-enabled cipher suites)"});
        }
        return ctx.getSocketFactory();
    }
}

