/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.mqttv5.client.websocket;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.eclipse.paho.mqttv5.client.MqttConnectionOptions;
import org.eclipse.paho.mqttv5.client.internal.NetworkModule;
import org.eclipse.paho.mqttv5.client.security.SSLSocketFactoryFactory;
import org.eclipse.paho.mqttv5.client.spi.NetworkModuleFactory;
import org.eclipse.paho.mqttv5.client.websocket.WebSocketSecureNetworkModule;
import org.eclipse.paho.mqttv5.common.ExceptionHelper;
import org.eclipse.paho.mqttv5.common.MqttException;

public class WebSocketSecureNetworkModuleFactory
implements NetworkModuleFactory {
    @Override
    public Set<String> getSupportedUriSchemes() {
        return Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("wss")));
    }

    @Override
    public void validateURI(URI brokerUri) throws IllegalArgumentException {
    }

    @Override
    public NetworkModule createNetworkModule(URI brokerUri, MqttConnectionOptions options2, String clientId) throws MqttException {
        String[] enabledCiphers;
        String host = brokerUri.getHost();
        int port = brokerUri.getPort();
        if (port == -1) {
            port = 443;
        }
        SocketFactory factory2 = options2.getSocketFactory();
        SSLSocketFactoryFactory wSSFactoryFactory = null;
        if (factory2 == null) {
            wSSFactoryFactory = new SSLSocketFactoryFactory();
            Properties sslClientProps = options2.getSSLProperties();
            if (sslClientProps != null) {
                wSSFactoryFactory.initialize(sslClientProps, null);
            }
            factory2 = wSSFactoryFactory.createSocketFactory(null);
        } else if (!(factory2 instanceof SSLSocketFactory)) {
            throw ExceptionHelper.createMqttException(32105);
        }
        WebSocketSecureNetworkModule netModule = new WebSocketSecureNetworkModule((SSLSocketFactory)factory2, brokerUri.toString(), host, port, clientId);
        netModule.setSSLhandshakeTimeout(options2.getConnectionTimeout());
        netModule.setSSLHostnameVerifier(options2.getSSLHostnameVerifier());
        netModule.setHttpsHostnameVerificationEnabled(options2.isHttpsHostnameVerificationEnabled());
        netModule.setCustomWebSocketHeaders(options2.getCustomWebSocketHeaders());
        if (wSSFactoryFactory != null && (enabledCiphers = wSSFactoryFactory.getEnabledCipherSuites(null)) != null) {
            netModule.setEnabledCiphers(enabledCiphers);
        }
        return netModule;
    }
}

