/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.mqttv5.client.wire;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.paho.mqttv5.client.internal.MqttState;
import org.eclipse.paho.mqttv5.client.logging.Logger;
import org.eclipse.paho.mqttv5.client.logging.LoggerFactory;
import org.eclipse.paho.mqttv5.common.ExceptionHelper;
import org.eclipse.paho.mqttv5.common.MqttException;
import org.eclipse.paho.mqttv5.common.packet.MqttWireMessage;

public class MqttOutputStream
extends OutputStream {
    private static final String CLASS_NAME = MqttOutputStream.class.getName();
    private Logger log = LoggerFactory.getLogger("org.eclipse.paho.mqttv5.client.internal.nls.logcat", CLASS_NAME);
    private MqttState clientState = null;
    private BufferedOutputStream out;

    public MqttOutputStream(MqttState clientState, OutputStream out2, String clientId) {
        this.clientState = clientState;
        this.out = new BufferedOutputStream(out2);
        this.log.setResourceName(clientId);
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.out.write(b);
        this.clientState.notifySentBytes(b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.clientState.notifySentBytes(len);
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
    }

    public void write(MqttWireMessage message) throws IOException, MqttException {
        byte[] bytes = message.getHeader();
        byte[] pl = message.getPayload();
        if (this.clientState.getOutgoingMaximumPacketSize() != null && (long)(bytes.length + pl.length) > this.clientState.getOutgoingMaximumPacketSize()) {
            throw ExceptionHelper.createMqttException(51002);
        }
        this.out.write(bytes, 0, bytes.length);
        this.clientState.notifySentBytes(bytes.length);
        int offset = 0;
        int chunckSize = 1024;
        while (offset < pl.length) {
            int length = Math.min(chunckSize, pl.length - offset);
            this.out.write(pl, offset, length);
            offset += chunckSize;
            this.clientState.notifySentBytes(length);
        }
        this.log.fine(CLASS_NAME, "write", "529", new Object[]{message});
    }
}

