/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.mqttv5.common.packet;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.paho.mqttv5.common.MqttException;
import org.eclipse.paho.mqttv5.common.packet.MqttProperties;
import org.eclipse.paho.mqttv5.common.packet.MqttWireMessage;
import org.eclipse.paho.mqttv5.common.packet.util.CountingInputStream;

public class MqttDisconnect
extends MqttWireMessage {
    public static final String KEY = "Disc";
    private static final int[] validReturnCodes;
    private int returnCode = 0;
    private static final Byte[] validProperties;
    private MqttProperties properties;

    static {
        int[] nArray = new int[29];
        nArray[1] = 4;
        nArray[2] = 128;
        nArray[3] = 129;
        nArray[4] = 130;
        nArray[5] = 131;
        nArray[6] = 135;
        nArray[7] = 137;
        nArray[8] = 139;
        nArray[9] = 141;
        nArray[10] = 142;
        nArray[11] = 143;
        nArray[12] = 144;
        nArray[13] = 147;
        nArray[14] = 148;
        nArray[15] = 149;
        nArray[16] = 150;
        nArray[17] = 151;
        nArray[18] = 152;
        nArray[19] = 153;
        nArray[20] = 154;
        nArray[21] = 155;
        nArray[22] = 156;
        nArray[23] = 157;
        nArray[24] = 158;
        nArray[25] = 159;
        nArray[26] = 160;
        nArray[27] = 161;
        nArray[28] = 162;
        validReturnCodes = nArray;
        validProperties = new Byte[]{(byte)17, (byte)28, (byte)31, (byte)38};
    }

    public MqttDisconnect(byte[] data2) throws IOException, MqttException {
        super((byte)14);
        long remainder;
        this.properties = new MqttProperties(validProperties);
        ByteArrayInputStream bais = new ByteArrayInputStream(data2);
        CountingInputStream counter = new CountingInputStream(bais);
        DataInputStream inputStream2 = new DataInputStream(counter);
        if (data2.length - counter.getCounter() >= 1) {
            this.returnCode = inputStream2.readUnsignedByte();
            this.validateReturnCode(this.returnCode, validReturnCodes);
        }
        if ((remainder = (long)data2.length - (long)counter.getCounter()) >= 2L) {
            this.properties.decodeProperties(inputStream2);
        }
        inputStream2.close();
    }

    public MqttDisconnect(int returnCode, MqttProperties properties2) throws MqttException {
        super((byte)14);
        this.validateReturnCode(returnCode, validReturnCodes);
        this.returnCode = returnCode;
        this.properties = properties2 != null ? properties2 : new MqttProperties();
        this.properties.setValidProperties(validProperties);
    }

    @Override
    protected byte[] getVariableHeader() throws MqttException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream outputStream2 = new DataOutputStream(baos);
            outputStream2.writeByte(this.returnCode);
            byte[] identifierValueFieldsByteArray = this.properties.encodeProperties();
            if (identifierValueFieldsByteArray.length != 0) {
                outputStream2.write(identifierValueFieldsByteArray);
                outputStream2.flush();
            }
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            throw new MqttException(ioe);
        }
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    @Override
    protected byte getMessageInfo() {
        return 0;
    }

    @Override
    public MqttProperties getProperties() {
        return this.properties;
    }

    @Override
    public String toString() {
        return "MqttDisconnect [returnCode=" + this.returnCode + ", properties=" + this.properties + "]";
    }
}

