/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.mqttv5.common.packet;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import org.eclipse.paho.mqttv5.common.MqttException;
import org.eclipse.paho.mqttv5.common.packet.MqttAck;
import org.eclipse.paho.mqttv5.common.packet.MqttProperties;
import org.eclipse.paho.mqttv5.common.packet.util.CountingInputStream;

public class MqttSubAck
extends MqttAck {
    private static final int[] validReturnCodes;
    private static final Byte[] validProperties;
    private MqttProperties properties;

    static {
        int[] nArray = new int[9];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 128;
        nArray[4] = 131;
        nArray[5] = 135;
        nArray[6] = 143;
        nArray[7] = 145;
        nArray[8] = 158;
        validReturnCodes = nArray;
        validProperties = new Byte[]{(byte)31, (byte)38};
    }

    public MqttSubAck(byte[] data2) throws IOException, MqttException {
        super((byte)9);
        this.properties = new MqttProperties(validProperties);
        ByteArrayInputStream bais = new ByteArrayInputStream(data2);
        CountingInputStream counter = new CountingInputStream(bais);
        DataInputStream inputStream2 = new DataInputStream(counter);
        this.msgId = inputStream2.readUnsignedShort();
        this.properties.decodeProperties(inputStream2);
        int remainingLength = data2.length - counter.getCounter();
        this.reasonCodes = new int[remainingLength];
        int i = 0;
        while (i < remainingLength) {
            int returnCode = inputStream2.readUnsignedByte();
            this.validateReturnCode(returnCode, validReturnCodes);
            this.reasonCodes[i] = returnCode;
            ++i;
        }
        inputStream2.close();
    }

    public MqttSubAck(int[] returnCodes, MqttProperties properties2) throws MqttException {
        super((byte)9);
        int[] nArray = returnCodes;
        int n = returnCodes.length;
        int n2 = 0;
        while (n2 < n) {
            int returnCode = nArray[n2];
            this.validateReturnCode(returnCode, validReturnCodes);
            ++n2;
        }
        this.reasonCodes = returnCodes;
        this.properties = properties2 != null ? properties2 : new MqttProperties();
        this.properties.setValidProperties(validProperties);
    }

    @Override
    protected byte[] getVariableHeader() throws MqttException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream outputStream2 = new DataOutputStream(baos);
            outputStream2.writeShort(this.msgId);
            byte[] identifierValueFieldsByteArray = this.properties.encodeProperties();
            outputStream2.write(identifierValueFieldsByteArray);
            outputStream2.flush();
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            throw new MqttException(ioe);
        }
    }

    @Override
    public byte[] getPayload() throws MqttException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream outputStream2 = new DataOutputStream(baos);
            int[] nArray = this.reasonCodes;
            int n = this.reasonCodes.length;
            int n2 = 0;
            while (n2 < n) {
                int returnCode = nArray[n2];
                outputStream2.writeByte(returnCode);
                ++n2;
            }
            outputStream2.flush();
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            throw new MqttException(ioe);
        }
    }

    public int[] getReturnCodes() {
        return this.reasonCodes;
    }

    public void setReturnCodes(int[] returnCodes) {
        this.reasonCodes = returnCodes;
    }

    @Override
    public MqttProperties getProperties() {
        return this.properties;
    }

    @Override
    public String toString() {
        return "MqttSubAck [returnCodes=" + Arrays.toString(this.reasonCodes) + ", properties=" + this.properties + "]";
    }
}

