/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.mqttv5.common.packet;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.paho.mqttv5.common.ExceptionHelper;
import org.eclipse.paho.mqttv5.common.MqttException;
import org.eclipse.paho.mqttv5.common.MqttPersistable;
import org.eclipse.paho.mqttv5.common.packet.MqttAuth;
import org.eclipse.paho.mqttv5.common.packet.MqttConnAck;
import org.eclipse.paho.mqttv5.common.packet.MqttConnect;
import org.eclipse.paho.mqttv5.common.packet.MqttDataTypes;
import org.eclipse.paho.mqttv5.common.packet.MqttDisconnect;
import org.eclipse.paho.mqttv5.common.packet.MqttPingReq;
import org.eclipse.paho.mqttv5.common.packet.MqttPingResp;
import org.eclipse.paho.mqttv5.common.packet.MqttProperties;
import org.eclipse.paho.mqttv5.common.packet.MqttPubAck;
import org.eclipse.paho.mqttv5.common.packet.MqttPubComp;
import org.eclipse.paho.mqttv5.common.packet.MqttPubRec;
import org.eclipse.paho.mqttv5.common.packet.MqttPubRel;
import org.eclipse.paho.mqttv5.common.packet.MqttPublish;
import org.eclipse.paho.mqttv5.common.packet.MqttSubAck;
import org.eclipse.paho.mqttv5.common.packet.MqttSubscribe;
import org.eclipse.paho.mqttv5.common.packet.MqttUnsubAck;
import org.eclipse.paho.mqttv5.common.packet.MqttUnsubscribe;
import org.eclipse.paho.mqttv5.common.packet.util.CountingInputStream;
import org.eclipse.paho.mqttv5.common.packet.util.MultiByteArrayInputStream;

public abstract class MqttWireMessage {
    public static final byte MESSAGE_TYPE_RESERVED = 0;
    public static final byte MESSAGE_TYPE_CONNECT = 1;
    public static final byte MESSAGE_TYPE_CONNACK = 2;
    public static final byte MESSAGE_TYPE_PUBLISH = 3;
    public static final byte MESSAGE_TYPE_PUBACK = 4;
    public static final byte MESSAGE_TYPE_PUBREC = 5;
    public static final byte MESSAGE_TYPE_PUBREL = 6;
    public static final byte MESSAGE_TYPE_PUBCOMP = 7;
    public static final byte MESSAGE_TYPE_SUBSCRIBE = 8;
    public static final byte MESSAGE_TYPE_SUBACK = 9;
    public static final byte MESSAGE_TYPE_UNSUBSCRIBE = 10;
    public static final byte MESSAGE_TYPE_UNSUBACK = 11;
    public static final byte MESSAGE_TYPE_PINGREQ = 12;
    public static final byte MESSAGE_TYPE_PINGRESP = 13;
    public static final byte MESSAGE_TYPE_DISCONNECT = 14;
    public static final byte MESSAGE_TYPE_AUTH = 15;
    protected static final String STRING_ENCODING = "UTF-8";
    protected static final String DEFAULT_PROTOCOL_NAME = "MQTT";
    protected static final int DEFAULT_PROTOCOL_VERSION = 5;
    private static final String[] PACKET_NAMES = new String[]{"reserved", "CONNECT", "CONNACK", "PUBLISH", "PUBACK", "PUBREC", "PUBREL", "PUBCOMP", "SUBSCRIBE", "SUBACK", "UNSUBSCRIBE", "UNSUBACK", "PINGREQ", "PINGRESP", "DISCONNECT", "AUTH"};
    private static final byte[] PACKET_RESERVED_MASKS;
    private byte type;
    MqttProperties properties = new MqttProperties();
    protected int msgId;
    protected int[] reasonCodes = null;
    protected int reasonCode = -1;
    protected boolean duplicate = false;

    static {
        byte[] byArray = new byte[16];
        byArray[6] = 2;
        byArray[8] = 2;
        byArray[10] = 2;
        PACKET_RESERVED_MASKS = byArray;
    }

    public MqttWireMessage(byte type2) {
        this.type = type2;
        this.msgId = 0;
    }

    protected abstract byte getMessageInfo();

    public byte[] getPayload() throws MqttException {
        return new byte[0];
    }

    public byte getType() {
        return this.type;
    }

    public int getMessageId() {
        return this.msgId;
    }

    public void setMessageId(int msgId) {
        this.msgId = msgId;
    }

    public String getKey() {
        return Integer.toString(this.getMessageId());
    }

    public byte[] getHeader() throws MqttException {
        try {
            int first2 = (this.getType() & 0xF) << 4 ^ this.getMessageInfo() & 0xF;
            byte[] varHeader = this.getVariableHeader();
            int remLen = varHeader.length + this.getPayload().length;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            dos.writeByte(first2);
            dos.write(MqttWireMessage.encodeVariableByteInteger(remLen));
            dos.write(varHeader);
            dos.flush();
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            throw new MqttException(ioe);
        }
    }

    protected abstract byte[] getVariableHeader() throws MqttException;

    public boolean isMessageIdRequired() {
        return true;
    }

    public static MqttWireMessage createWireMessage(MqttPersistable data2) throws MqttException {
        byte[] payload = data2.getPayloadBytes();
        if (payload == null) {
            payload = new byte[]{};
        }
        MultiByteArrayInputStream mbais = new MultiByteArrayInputStream(data2.getHeaderBytes(), data2.getHeaderOffset(), data2.getHeaderLength(), payload, data2.getPayloadOffset(), data2.getPayloadLength());
        return MqttWireMessage.createWireMessage(mbais);
    }

    public static MqttWireMessage createWireMessage(byte[] bytes) throws MqttException {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        return MqttWireMessage.createWireMessage(bais);
    }

    private static MqttWireMessage createWireMessage(InputStream inputStream2) throws MqttException {
        try {
            MqttWireMessage result2;
            CountingInputStream counter = new CountingInputStream(inputStream2);
            DataInputStream in = new DataInputStream(counter);
            int first2 = in.readUnsignedByte();
            byte type2 = (byte)(first2 >> 4);
            byte info = (byte)(first2 &= 0xF);
            long remLen = MqttDataTypes.readVariableByteInteger(in).getValue();
            long totalToRead = (long)counter.getCounter() + remLen;
            long remainder = totalToRead - (long)counter.getCounter();
            byte[] data2 = new byte[]{};
            if (remainder > 0L) {
                data2 = new byte[(int)remainder];
                in.readFully(data2, 0, data2.length);
            }
            switch (type2) {
                case 1: {
                    result2 = new MqttConnect(info, data2);
                    break;
                }
                case 2: {
                    result2 = new MqttConnAck(data2);
                    break;
                }
                case 3: {
                    result2 = new MqttPublish(info, data2);
                    break;
                }
                case 4: {
                    result2 = new MqttPubAck(data2);
                    break;
                }
                case 5: {
                    result2 = new MqttPubRec(data2);
                    break;
                }
                case 6: {
                    result2 = new MqttPubRel(data2);
                    break;
                }
                case 7: {
                    result2 = new MqttPubComp(data2);
                    break;
                }
                case 8: {
                    result2 = new MqttSubscribe(data2);
                    break;
                }
                case 9: {
                    result2 = new MqttSubAck(data2);
                    break;
                }
                case 10: {
                    result2 = new MqttUnsubscribe(data2);
                    break;
                }
                case 11: {
                    result2 = new MqttUnsubAck(data2);
                    break;
                }
                case 12: {
                    result2 = new MqttPingReq();
                    break;
                }
                case 13: {
                    result2 = new MqttPingResp();
                    break;
                }
                case 14: {
                    result2 = new MqttDisconnect(data2);
                    break;
                }
                case 15: {
                    result2 = new MqttAuth(data2);
                    break;
                }
                default: {
                    throw ExceptionHelper.createMqttException(50002);
                }
            }
            return result2;
        }
        catch (IOException ioe) {
            throw new MqttException(ioe);
        }
    }

    public static byte[] encodeVariableByteInteger(int number) {
        int numBytes = 0;
        long no = number;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        do {
            byte digit = (byte)(no % 128L);
            if ((no /= 128L) > 0L) {
                digit = (byte)(digit | 0x80);
            }
            baos.write(digit);
        } while (no > 0L && ++numBytes < 4);
        return baos.toByteArray();
    }

    public static void validateReservedBits(byte type2, byte reserved) throws MqttException, IllegalArgumentException {
        if (type2 == 3) {
            return;
        }
        if (type2 > 15) {
            throw new IllegalArgumentException("Unrecognised Message Type.");
        }
        if (reserved != PACKET_RESERVED_MASKS[type2]) {
            throw new MqttException(50002);
        }
    }

    protected byte[] encodeMessageId() throws MqttException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            dos.writeShort(this.msgId);
            dos.flush();
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            throw new MqttException(ioe);
        }
    }

    public boolean isRetryable() {
        return false;
    }

    public void setDuplicate(boolean duplicate) {
        this.duplicate = duplicate;
    }

    public boolean isDuplicate() {
        return this.duplicate;
    }

    public MqttProperties getProperties() {
        return this.properties;
    }

    public void setProperties(MqttProperties properties2) {
        this.properties = properties2;
    }

    public String toString() {
        return PACKET_NAMES[this.type];
    }

    protected void validateReturnCode(int returnCode, int[] validReturnCodes) throws MqttException {
        int[] nArray = validReturnCodes;
        int n = validReturnCodes.length;
        int n2 = 0;
        while (n2 < n) {
            int validReturnCode = nArray[n2];
            if (returnCode == validReturnCode) {
                return;
            }
            ++n2;
        }
        throw new MqttException(50001);
    }

    public int[] getReasonCodes() {
        if (this.reasonCodes != null) {
            return this.reasonCodes;
        }
        if (this.reasonCode != -1) {
            return new int[]{this.reasonCode};
        }
        return null;
    }

    public byte[] serialize() throws MqttException {
        byte[] a = this.getHeader();
        byte[] b = this.getPayload();
        byte[] c = new byte[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }
}

