/*
 * Decompiled with CFR 0.152.
 */
package org.tomlj;

import java.util.Optional;
import org.tomlj.MutableTomlArray;
import org.tomlj.TomlInvalidTypeException;
import org.tomlj.TomlPosition;
import org.tomlj.TomlType;

final class MutableHomogeneousTomlArray
extends MutableTomlArray {
    private TomlType type = null;

    MutableHomogeneousTomlArray(boolean tableArray) {
        super(tableArray);
    }

    @Override
    public boolean containsStrings() {
        return this.type == null || this.type == TomlType.STRING;
    }

    @Override
    public boolean containsLongs() {
        return this.type == null || this.type == TomlType.INTEGER;
    }

    @Override
    public boolean containsDoubles() {
        return this.type == null || this.type == TomlType.FLOAT;
    }

    @Override
    public boolean containsBooleans() {
        return this.type == null || this.type == TomlType.BOOLEAN;
    }

    @Override
    public boolean containsOffsetDateTimes() {
        return this.type == null || this.type == TomlType.OFFSET_DATE_TIME;
    }

    @Override
    public boolean containsLocalDateTimes() {
        return this.type == null || this.type == TomlType.LOCAL_DATE_TIME;
    }

    @Override
    public boolean containsLocalDates() {
        return this.type == null || this.type == TomlType.LOCAL_DATE;
    }

    @Override
    public boolean containsLocalTimes() {
        return this.type == null || this.type == TomlType.LOCAL_TIME;
    }

    @Override
    public boolean containsArrays() {
        return this.type == null || this.type == TomlType.ARRAY;
    }

    @Override
    public boolean containsTables() {
        return this.type == null || this.type == TomlType.TABLE;
    }

    @Override
    public MutableHomogeneousTomlArray append(Object value2, TomlPosition position) {
        if (value2 instanceof Integer) {
            value2 = ((Integer)value2).longValue();
        }
        TomlType origType = this.type;
        Optional<TomlType> valueType = TomlType.typeFor(value2);
        if (!valueType.isPresent()) {
            throw new IllegalArgumentException("Unsupported type " + value2.getClass().getSimpleName());
        }
        if (this.type != null) {
            if (valueType.get() != this.type) {
                throw new TomlInvalidTypeException("Cannot add a " + TomlType.typeNameFor(value2) + " to an array containing " + this.type.typeName() + "s");
            }
        } else {
            this.type = valueType.get();
        }
        try {
            super.append(value2, position);
        }
        catch (Throwable e) {
            this.type = origType;
            throw e;
        }
        return this;
    }
}

